/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.convert.serialize;

import com.ibm.cognos.internal.annotations.convert.serialize.Serializer;
import com.ibm.cognos.internal.annotations.convert.serialize.SerializerContext;
import com.ibm.cognos.internal.annotations.convert.serialize.SerializerFactory;
import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.pojos.DataItem;
import com.ibm.cognos.internal.annotations.pojos.DimensionMember;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class DimensionMemberSerializer
implements Serializer {
    private DimensionMember dimensionMember;
    private SerializerFactory factory;
    private SerializerContext context;

    public DimensionMemberSerializer(DimensionMember dimensionMember, SerializerContext context, SerializerFactory factory) {
        this.dimensionMember = dimensionMember;
        this.factory = factory;
        this.context = context;
    }

    @Override
    public Element convert() throws AnnotationServiceException {
        Document document = DocumentHelper.createDocument();
        Serializer dimensionBuilder = this.factory.getSerializer(this.dimensionMember.getDimension(), this.context);
        Element dimensionElement = dimensionBuilder.convert();
        Element valueElement = document.addElement("value");
        Element itemElement = valueElement.addElement("item");
        for (DataItem dataItem : this.dimensionMember.getDataItems()) {
            String name = dataItem.getName();
            String value = dataItem.getValue();
            Element dataItemElement = itemElement.addElement(name);
            if (value == null) continue;
            dataItemElement.addText(dataItem.getValue());
        }
        valueElement.detach();
        Element dimItemElement = (Element)dimensionElement.selectSingleNode("./*[local-name()='item']");
        if (dimItemElement != null) {
            dimItemElement.add(valueElement);
        }
        return dimensionElement;
    }
}

