/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.convert.serialize;

import com.ibm.cognos.internal.annotations.convert.serialize.Serializer;
import com.ibm.cognos.internal.annotations.convert.serialize.SerializerContext;
import com.ibm.cognos.internal.annotations.convert.serialize.SerializerFactory;
import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.pojos.Dimension;
import com.ibm.cognos.internal.annotations.pojos.MetadataItem;
import java.util.Hashtable;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class DimensionSerializer
implements Serializer {
    private Dimension dimension;
    private SerializerFactory factory;
    private SerializerContext context;

    public DimensionSerializer(Dimension dimension, SerializerContext context, SerializerFactory factory) {
        this.dimension = dimension;
        this.factory = factory;
        this.context = context;
    }

    @Override
    public Element convert() throws AnnotationServiceException {
        Document document = DocumentHelper.createDocument();
        Hashtable<String, MetadataItem> metadataItemHash = new Hashtable<String, MetadataItem>();
        for (MetadataItem item : this.dimension.getMetadataItems()) {
            metadataItemHash.put(item.getName(), item);
        }
        String elementName = metadataItemHash.containsKey("#local-name()") ? ((MetadataItem)metadataItemHash.remove("#local-name()")).getValue() : "row";
        Element dimElement = document.addElement(elementName);
        Element itemElement = dimElement.addElement("item");
        MetadataItem nameMeta = (MetadataItem)metadataItemHash.remove("name");
        Element nameElement = itemElement.addElement("name");
        String nameMetaValue = nameMeta == null ? "name" : nameMeta.getValue();
        nameElement.addText(nameMetaValue);
        if (metadataItemHash.containsKey("#./selectAll")) {
            Element selectAllElement = dimElement.addElement("selectAll");
            selectAllElement.addText(((MetadataItem)metadataItemHash.remove("#./selectAll")).getValue());
        }
        Iterator keyIt = metadataItemHash.keySet().iterator();
        while (keyIt.hasNext()) {
            MetadataItem metaItem = (MetadataItem)metadataItemHash.get(keyIt.next());
            String name = metaItem.getName();
            String value = metaItem.getValue();
            value = value == null ? "" : value;
            dimElement.addAttribute(name, value);
        }
        dimElement.detach();
        return dimElement;
    }
}

