/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.convert.serialize;

import com.ibm.cognos.internal.annotations.convert.serialize.AnnotationSerializer;
import com.ibm.cognos.internal.annotations.convert.serialize.ContextSerializer;
import com.ibm.cognos.internal.annotations.convert.serialize.DimensionMemberSerializer;
import com.ibm.cognos.internal.annotations.convert.serialize.DimensionSerializer;
import com.ibm.cognos.internal.annotations.convert.serialize.Serializer;
import com.ibm.cognos.internal.annotations.convert.serialize.SerializerContext;
import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import com.ibm.cognos.internal.annotations.pojos.Annotation;
import com.ibm.cognos.internal.annotations.pojos.Context;
import com.ibm.cognos.internal.annotations.pojos.Dimension;
import com.ibm.cognos.internal.annotations.pojos.DimensionMember;
import java.lang.reflect.Constructor;
import java.util.Hashtable;

public class SerializerFactory {
    Hashtable<Class, Class<? extends Serializer>> serializerMap = new Hashtable();
    Hashtable<Class, Serializer> serializerMapOverrides = new Hashtable();

    public SerializerFactory() {
        this.serializerMap.put(Annotation.class, AnnotationSerializer.class);
        this.serializerMap.put(Context.class, ContextSerializer.class);
        this.serializerMap.put(Dimension.class, DimensionSerializer.class);
        this.serializerMap.put(DimensionMember.class, DimensionMemberSerializer.class);
    }

    public Serializer getSerializer(Object objConvert, SerializerContext context) throws AnnotationServiceException {
        Serializer serializer = null;
        Serializer override = this.serializerMapOverrides.get(objConvert.getClass());
        if (override != null) {
            serializer = override;
        } else {
            Class<? extends Serializer> serializerClass = this.serializerMap.get(objConvert.getClass());
            if (serializerClass != null) {
                try {
                    Constructor<? extends Serializer> constructor = serializerClass.getConstructor(objConvert.getClass(), SerializerContext.class, this.getClass());
                    serializer = constructor.newInstance(objConvert, context, this);
                }
                catch (Exception e) {
                    throw new AnnotationServiceException(AnnotationI18NCode.SERIALIZER_CONSTRUCTOR_ERROR, new Object[]{objConvert.getClass().getName()}, e);
                }
            } else {
                throw new AnnotationServiceException(AnnotationI18NCode.SERIALIZER_NOT_FOUND, new Object[]{objConvert.getClass().getName()});
            }
        }
        return serializer;
    }

    void addSerializer(Class classToSerialize, Class<? extends Serializer> serializer) {
        this.serializerMap.put(classToSerialize, serializer);
    }

    void addSerializerOverride(Class classToSerialize, Serializer serializer) {
        this.serializerMapOverrides.put(classToSerialize, serializer);
    }
}

