/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.dao.impl;

import com.ibm.cognos.internal.annotations.dao.AnnotationDAO;
import com.ibm.cognos.internal.annotations.dao.impl.GenericDAOImpl;
import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import com.ibm.cognos.internal.annotations.pojos.Annotation;
import com.ibm.cognos.internal.annotations.query.QueryBuilder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TemporalType;

public class AnnotationDAOImpl
extends GenericDAOImpl<Annotation, Long>
implements AnnotationDAO {
    @Override
    public Query findNewUpdatedAnnotations(EntityManager em, Date since) {
        Query query = em.createQuery("select annotation from Annotation annotation where annotation.creationTime >= :createTime or annotation.lastModificationTime > :lastModTime");
        query.setParameter("createTime", since, TemporalType.DATE);
        query.setParameter("lastModTime", since, TemporalType.DATE);
        return query;
    }

    @Override
    public Query findAnnotationsGivenIDs(EntityManager em, List<Long> idList) {
        Query query = em.createQuery("select annotation from Annotation annotation where annotation.id in (:list)");
        query.setParameter("list", idList);
        return query;
    }

    @Override
    public Query findAnnotationsByParentIDs(EntityManager em, String parentID, String secondaryParentID) {
        Query query = null;
        if (secondaryParentID != null) {
            query = em.createQuery("select annotation from Annotation annotation where annotation.parentId= :parentID and annotation.secondaryParentId= :secondParentID");
            query.setParameter("parentID", (Object)parentID);
            query.setParameter("secondParentID", (Object)secondaryParentID);
        } else {
            query = em.createQuery("select annotation from Annotation annotation where annotation.parentId= :parentID");
            query.setParameter("parentID", (Object)parentID);
        }
        return query;
    }

    @Override
    public Query findAnnotationsOlderThan(EntityManager em, Date time) {
        Query query = em.createQuery("select annotation from Annotation annotation where annotation.creationTime <= :createTime");
        query.setParameter("createTime", time, TemporalType.DATE);
        return query;
    }

    @Override
    public Query findAnnotationByAttributes(EntityManager em, Annotation querySourceAnnotation) {
        String selectClause = "select annotation from Annotation annotation join annotation.text text";
        String whereClause = " where ";
        Query query = null;
        QueryBuilder queryBuilder = new QueryBuilder();
        queryBuilder.addToSelectStatement(selectClause);
        queryBuilder.addToWhereClause(whereClause);
        if (querySourceAnnotation.getParentId() != null) {
            queryBuilder.addToWhereClause("annotation.parentId = :parentId ");
            queryBuilder.setParameter("parentId", querySourceAnnotation.getParentId());
        } else {
            queryBuilder.addToWhereClause("annotation.parentId is null ");
        }
        if (querySourceAnnotation.getSecondaryParentId() != null) {
            queryBuilder.addToWhereClause("and annotation.secondaryParentId = :secondaryParentId ");
            queryBuilder.setParameter("secondaryParentId", querySourceAnnotation.getSecondaryParentId());
        } else {
            queryBuilder.addToWhereClause("and annotation.secondaryParentId is null ");
        }
        if (querySourceAnnotation.getLocale() != null) {
            queryBuilder.addToWhereClause("and annotation.locale = :locale ");
            queryBuilder.setParameter("locale", querySourceAnnotation.getLocale());
        } else {
            queryBuilder.addToWhereClause("and annotation.locale is null ");
        }
        if (querySourceAnnotation.getText().getName() != null) {
            queryBuilder.addToWhereClause("and text.name = :name ");
            queryBuilder.setParameter("name", querySourceAnnotation.getText().getName());
        } else {
            queryBuilder.addToWhereClause("and text.name is null ");
        }
        if (querySourceAnnotation.getText().getDescription() != null) {
            queryBuilder.addToWhereClause("and text.description = :description ");
            queryBuilder.setParameter("description", querySourceAnnotation.getText().getDescription());
        } else {
            queryBuilder.addToWhereClause("and text.description is null ");
        }
        if (querySourceAnnotation.getOwner() != null) {
            queryBuilder.addToWhereClause("and annotation.owner = :owner ");
            queryBuilder.setParameter("owner", querySourceAnnotation.getOwner());
        } else {
            queryBuilder.addToWhereClause("and annotation.owner is null ");
        }
        if (querySourceAnnotation.getCreationTime() != null) {
            queryBuilder.addToWhereClause("and annotation.creationTime = :creationtime ");
            queryBuilder.setParameter("creationtime", querySourceAnnotation.getCreationTime(), TemporalType.DATE);
        } else {
            queryBuilder.addToWhereClause("and annotation.creationTime is null ");
        }
        if (querySourceAnnotation.getLastModificationTime() != null) {
            queryBuilder.addToWhereClause("and annotation.lastModificationTime = :lastModTime");
            queryBuilder.setParameter("lastModTime", querySourceAnnotation.getLastModificationTime(), TemporalType.DATE);
        } else {
            queryBuilder.addToWhereClause("and annotation.lastModificationTime is null");
        }
        query = queryBuilder.buildQuery(em);
        return query;
    }

    @Override
    public Query deleteAnnotationByID(EntityManager em, Long id) {
        Query propQuery = em.createQuery("delete from AnnotationProperty a WHERE a.annotation.id IN (select b.id from Annotation b where b.id = :id)");
        propQuery.setParameter("id", (Object)id);
        propQuery.executeUpdate();
        Query query = em.createQuery("delete from Annotation a WHERE a.id = :id");
        query.setParameter("id", (Object)id);
        return query;
    }

    @Override
    public Query deleteAnnotationByIDWithMatchingOwner(EntityManager em, Long id, String ownerID) {
        Query propQuery = em.createQuery("delete from AnnotationProperty a WHERE a.annotation.id IN (select b.id from Annotation b WHERE b.id = :id and b.owner = :owner)");
        propQuery.setParameter("id", (Object)id);
        propQuery.setParameter("owner", (Object)ownerID);
        propQuery.executeUpdate();
        Query query = em.createQuery("delete from Annotation a WHERE a.id = :id and a.owner = :owner");
        query.setParameter("id", (Object)id);
        query.setParameter("owner", (Object)ownerID);
        return query;
    }

    @Override
    public Query deleteAnnotationByIDList(EntityManager em, List<Long> idList) {
        Query propQuery = em.createQuery("delete from AnnotationProperty a WHERE a.annotation.id IN (select b.id from Annotation b where b.id IN (:list))");
        propQuery.setParameter("list", idList);
        propQuery.executeUpdate();
        Query query = em.createQuery("delete from Annotation a where a.id IN (:list)");
        query.setParameter("list", idList);
        return query;
    }

    @Override
    public Query deleteAnnotationByIDListWithMatchingOwner(EntityManager em, List<Long> idList, String ownerID) {
        Query propQuery = em.createQuery("delete from AnnotationProperty a WHERE a.annotation.id IN (select b.id from Annotation b where b.id IN (:list) and b.owner = :owner)");
        propQuery.setParameter("list", idList);
        propQuery.setParameter("owner", (Object)ownerID);
        propQuery.executeUpdate();
        Query query = em.createQuery("delete from Annotation a where a.id IN (:list) and a.owner = :owner");
        query.setParameter("list", idList);
        query.setParameter("owner", (Object)ownerID);
        return query;
    }

    @Override
    public Query deleteAnnotationByParentIDs(EntityManager em, String parentID, String secondaryParentID) {
        Query query = null;
        if (secondaryParentID != null) {
            Query propQuery = em.createQuery("delete from AnnotationProperty a WHERE a.annotation.id IN (select b.id from Annotation b where b.parentId= :parentID and b.secondaryParentId= :secondParentID)");
            propQuery.setParameter("parentID", (Object)parentID);
            propQuery.setParameter("secondParentID", (Object)secondaryParentID);
            propQuery.executeUpdate();
            query = em.createQuery("delete from Annotation a WHERE a.parentId= :parentID and a.secondaryParentId= :secondParentID");
            query.setParameter("parentID", (Object)parentID);
            query.setParameter("secondParentID", (Object)secondaryParentID);
        } else {
            Query propQuery = em.createQuery("delete from AnnotationProperty a WHERE a.annotation.id IN (select b.id from Annotation b WHERE b.parentId= :parentID)");
            propQuery.setParameter("parentID", (Object)parentID);
            propQuery.executeUpdate();
            query = em.createQuery("delete from Annotation a WHERE a.parentId= :parentID");
            query.setParameter("parentID", (Object)parentID);
        }
        return query;
    }

    @Override
    public Query deleteAnnotationByParentIDWithMatchingOwner(EntityManager em, String parentID, String ownerID) {
        Query propQuery = em.createQuery("delete from AnnotationProperty a WHERE a.annotation.id IN (select b.id from Annotation b WHERE b.parentId = :parentId and b.owner = :owner)");
        propQuery.setParameter("parentId", (Object)parentID);
        propQuery.setParameter("owner", (Object)ownerID);
        propQuery.executeUpdate();
        Query query = em.createQuery("delete from Annotation a WHERE a.parentId = :parentId and a.owner = :owner");
        query.setParameter("parentId", (Object)parentID);
        query.setParameter("owner", (Object)ownerID);
        return query;
    }

    @Override
    public Query deleteAnnotationsOlderThan(EntityManager em, Date time) {
        Query propQuery = em.createQuery("delete from AnnotationProperty a WHERE a.annotation.id IN (select b.id from Annotation b where b.creationTime <= :createTime)");
        propQuery.setParameter("createTime", time, TemporalType.DATE);
        propQuery.executeUpdate();
        Query query = em.createQuery("delete from Annotation annotation where annotation.creationTime <= :createTime");
        query.setParameter("createTime", time, TemporalType.DATE);
        return query;
    }

    @Override
    public int deleteUnusedText(Connection connection) throws AnnotationServiceException {
        String text = "delete from ANN_ANNOTATION_TEXT where ANN_ANNOTATION_TEXT.id IN (select ANN_ANNOTATION_TEXT.id from ANN_ANNOTATION_TEXT LEFT OUTER JOIN ANN_ANNOTATION on ANN_ANNOTATION.textId = ANN_ANNOTATION_TEXT.id where ANN_ANNOTATION.id is NULL)";
        PreparedStatement textStmnt = null;
        int deletedText = 0;
        try {
            textStmnt = connection.prepareStatement(text);
            deletedText = textStmnt.executeUpdate();
            textStmnt.close();
        }
        catch (SQLException e) {
            if (textStmnt != null) {
                try {
                    textStmnt.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throw new AnnotationServiceException(AnnotationI18NCode.SQL_EXCEPTION_WHILE_CLEANING, new Object[]{AnnotationI18NCode.TEXT_TYPE}, e);
        }
        return deletedText;
    }

    @Override
    public void updateMSSQLdateTime(Connection connection) throws AnnotationServiceException {
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            stmt.execute("UPDATE ANN_ANNOTATION SET creationTime = '1753-01-01' WHERE creationTime < '1753-01-01'");
            stmt.execute("UPDATE ANN_ANNOTATION SET lastModificationTime = '1753-01-01' WHERE lastModificationTime < '1753-01-01'");
            stmt.execute("ALTER TABLE ANN_ANNOTATION ALTER COLUMN creationTime datetime");
            stmt.execute("ALTER TABLE ANN_ANNOTATION ALTER COLUMN lastModificationTime datetime");
            connection.commit();
        }
        catch (SQLException e) {
            throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_GENERAL_ERROR, e, AnnotationServiceException.FaultType.SERVER_ERROR);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                    stmt = null;
                }
                catch (SQLException sQLException) {}
            }
        }
    }
}

