/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.dao.impl;

import com.ibm.cognos.internal.annotations.dao.AnnotationDAO;
import com.ibm.cognos.internal.annotations.dao.ContextDAO;
import com.ibm.cognos.internal.annotations.dao.DataItemDAO;
import com.ibm.cognos.internal.annotations.dao.DimensionDAO;
import com.ibm.cognos.internal.annotations.dao.DimensionMemberDAO;
import com.ibm.cognos.internal.annotations.dao.MetadataItemDAO;
import com.ibm.cognos.internal.annotations.dao.ModelDAO;
import com.ibm.cognos.internal.annotations.dao.VersionDAO;
import com.ibm.cognos.internal.annotations.dao.impl.AnnotationDAOImpl;
import com.ibm.cognos.internal.annotations.dao.impl.ContextDAOImpl;
import com.ibm.cognos.internal.annotations.dao.impl.DataItemDAOImpl;
import com.ibm.cognos.internal.annotations.dao.impl.DimensionDAOImpl;
import com.ibm.cognos.internal.annotations.dao.impl.DimensionMemberDAOImpl;
import com.ibm.cognos.internal.annotations.dao.impl.MetadataItemDAOImpl;
import com.ibm.cognos.internal.annotations.dao.impl.ModelDAOImpl;
import com.ibm.cognos.internal.annotations.dao.impl.VersionDAOImpl;
import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import java.util.HashMap;
import java.util.Map;

public class DAOFactory {
    private Map<Class<?>, Class<?>> daoMap = new HashMap();
    private Map<Class<?>, Object> daoOverrideMap = new HashMap();

    public DAOFactory() {
        this.setDAO(AnnotationDAO.class, AnnotationDAOImpl.class);
        this.setDAO(ContextDAO.class, ContextDAOImpl.class);
        this.setDAO(DataItemDAO.class, DataItemDAOImpl.class);
        this.setDAO(DimensionDAO.class, DimensionDAOImpl.class);
        this.setDAO(DimensionMemberDAO.class, DimensionMemberDAOImpl.class);
        this.setDAO(MetadataItemDAO.class, MetadataItemDAOImpl.class);
        this.setDAO(ModelDAO.class, ModelDAOImpl.class);
        this.setDAO(VersionDAO.class, VersionDAOImpl.class);
    }

    public <T> T buildDAO(Class<T> daoInterface) throws AnnotationServiceException {
        Object dao = null;
        if (this.daoOverrideMap.containsKey(daoInterface)) {
            dao = this.daoOverrideMap.get(daoInterface);
        } else {
            Class<?> mappedInterface = this.daoMap.get(daoInterface);
            if (mappedInterface != null) {
                try {
                    dao = mappedInterface.newInstance();
                }
                catch (Exception e) {
                    throw new AnnotationServiceException(AnnotationI18NCode.DOA_CONSTRUCTOR_ERROR, new Object[]{daoInterface.getName()}, e);
                }
            } else {
                throw new AnnotationServiceException(AnnotationI18NCode.DOA_NOT_FOUND, new Object[]{daoInterface.getName()});
            }
        }
        return (T)dao;
    }

    public <T> void setDAO(Class<T> daoInterface, Class<? extends T> daoImpl) {
        this.daoMap.put(daoInterface, daoImpl);
    }

    public <T> void setDAOOverride(Class<T> daoInterface, Object daoImpl) {
        this.daoOverrideMap.put(daoInterface, daoImpl);
    }
}

