/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.dao.impl;

import com.ibm.cognos.internal.annotations.dao.VersionDAO;
import com.ibm.cognos.internal.annotations.dao.impl.GenericDAOImpl;
import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import com.ibm.cognos.internal.annotations.pojos.Version;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;

public class VersionDAOImpl
extends GenericDAOImpl<Version, Long>
implements VersionDAO {
    @Override
    public int getVersion(EntityManager em) {
        Query query = em.createQuery("select a from Version a order by a.version desc");
        query.setMaxResults(1);
        List results = query.getResultList();
        Version theOne = results == null || results.size() == 0 ? null : (Version)results.get(0);
        return theOne == null ? -1 : theOne.getVersion();
    }

    @Override
    public int getNativeVersion(Connection con) throws AnnotationServiceException {
        PreparedStatement versionStatement = null;
        ResultSet resultSet = null;
        int version = 0;
        try {
            versionStatement = con.prepareStatement("select version from ANN_VERSION");
            resultSet = versionStatement.executeQuery();
            version = 2;
            while (resultSet.next()) {
                int tempVersion = resultSet.getInt(1);
                if (tempVersion <= version) continue;
                version = tempVersion;
            }
        }
        catch (SQLException e) {
            throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_GENERAL_ERROR, new Object[]{AnnotationI18NCode.TEXT_TYPE}, e);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (versionStatement != null) {
                    versionStatement.close();
                    versionStatement = null;
                }
            }
            catch (SQLException sQLException) {}
        }
        return version;
    }
}

