/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.exceptions;

import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import java.util.Locale;
import org.dom4j.Element;
import org.dom4j.Node;

public class AnnotationAuthenticationException
extends AnnotationServiceException {
    public AnnotationAuthenticationException(EMFSecurityException e) {
        super(AnnotationI18NCode.CAM_SECURITY_EXCEPTION, e, AnnotationServiceException.FaultType.FORBIDDEN);
    }

    @Override
    public void generateRESTDetails(Element errorElement, Locale locale) {
        Node errorCodeStringNode;
        BIBusEnvelope camExceptionEnvelope = ((EMFSecurityException)this.getCause()).getBIBusEnvelope();
        String code = "camAuthUserRecoverable";
        if (camExceptionEnvelope != null && (errorCodeStringNode = camExceptionEnvelope.getBIBusHeader().selectSingleNode("*[local-name()='CAM']/*[local-name()='exception']/*[local-name()='errorCodeString']")) != null) {
            code = errorCodeStringNode.getText();
        }
        Element codeElement = errorElement.addElement("code");
        Element messageElement = errorElement.addElement("message");
        Element detailElement = errorElement.addElement("detail");
        codeElement.setText(code);
        messageElement.setText(this.getUserLocaleMessage(locale));
    }

    @Override
    public BIBusEnvelope generateFault(MessageContext mc) {
        BIBusEnvelope faultEnvelope = ((EMFSecurityException)this.getCause()).getBIBusEnvelope();
        if (faultEnvelope == null) {
            faultEnvelope = super.generateFault(mc);
        }
        return faultEnvelope;
    }
}

