/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.exceptions;

import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import com.ibm.cognos.internal.annotations.i18n.MessageResources;
import com.ibm.cognos.internal.annotations.service.XMLSOAPHelper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.Locale;
import javax.persistence.PersistenceException;
import org.apache.openjpa.persistence.RollbackException;
import org.dom4j.Element;

public class AnnotationServiceException
extends Exception {
    private static final String SERVER_FAULT = "Server";
    private static final String CLIENT_FAULT = "Client";
    private FaultType fault = FaultType.SERVER_ERROR;
    private AnnotationI18NCode code;
    private Object[] params;

    public void generateDetails(Element detailsElement, Locale locale) {
        Element annotationFault = detailsElement.addElement(XMLSOAPHelper.ANN_FAULT_ELEMENT);
        Element annotationMessage = annotationFault.addElement(XMLSOAPHelper.ANN_FAULT_MESSAGE_ELEMENT);
        annotationMessage.setText(this.getUserLocaleMessage(locale));
        String trace = this.getTrace();
        if (trace != null) {
            Element traceElement = annotationFault.addElement(XMLSOAPHelper.ANN_FAULT_TRACE_ELEMENT);
            traceElement.setText(trace);
        }
    }

    public void generateRESTDetails(Element errorElement, Locale locale) {
        Element message = errorElement.addElement("message");
        message.setText(this.getUserLocaleMessage(locale));
    }

    public AnnotationServiceException(AnnotationI18NCode code) {
        this.code = code;
    }

    public AnnotationServiceException(AnnotationI18NCode code, FaultType fault) {
        this.code = code;
        this.fault = fault;
    }

    public AnnotationServiceException(AnnotationI18NCode code, Throwable nestedException) {
        super(nestedException);
        this.code = code;
    }

    public AnnotationServiceException(AnnotationI18NCode code, Throwable nestedException, FaultType fault) {
        super(nestedException);
        this.code = code;
        this.fault = fault;
    }

    public AnnotationServiceException(AnnotationI18NCode code, Object[] params) {
        this.code = code;
        this.params = params;
    }

    public AnnotationServiceException(AnnotationI18NCode code, Object[] params, FaultType fault) {
        this.code = code;
        this.params = params;
        this.fault = fault;
    }

    public AnnotationServiceException(AnnotationI18NCode code, Object[] params, Throwable nestedException) {
        super(nestedException);
        this.code = code;
        this.params = params;
    }

    public AnnotationServiceException(AnnotationI18NCode code, Object[] params, Throwable nestedException, FaultType fault) {
        super(nestedException);
        this.code = code;
        this.params = params;
        this.fault = fault;
    }

    public AnnotationI18NCode getCode() {
        return this.code;
    }

    public FaultType getFault() {
        return this.fault;
    }

    public String getServerLocaleMessage() {
        String serverLocaleString = null;
        try {
            serverLocaleString = this.getProperties().getProperty("serverLocale");
        }
        catch (PropertiesException propertiesException) {
            // empty catch block
        }
        return this.params == null ? MessageResources.getInstance().getResMessage(this.code, new Locale(serverLocaleString)) : MessageResources.getInstance().getResMessage(this.code, this.params, new Locale(serverLocaleString));
    }

    public String getUserLocaleMessage(Locale locale) {
        return this.params == null ? MessageResources.getInstance().getResMessage(this.code, locale) : MessageResources.getInstance().getResMessage(this.code, this.params, locale);
    }

    public String getTrace() {
        StringWriter sWriter = new StringWriter();
        PrintWriter pWriter = new PrintWriter(sWriter);
        Throwable t = this;
        do {
            t.printStackTrace(pWriter);
        } while ((t = t.getCause()) != null);
        return sWriter.toString();
    }

    public boolean isRetryException() {
        Throwable e = this;
        boolean isRetryException = false;
        while (e instanceof AnnotationServiceException) {
            e = e.getCause();
        }
        if (e instanceof SQLException) {
            isRetryException = true;
        } else if (e instanceof PersistenceException) {
            isRetryException = true;
        } else if (e instanceof RollbackException || e instanceof javax.persistence.RollbackException) {
            isRetryException = true;
        }
        return isRetryException;
    }

    protected CRNProperties getProperties() {
        return CRNProperties.getInstance();
    }

    public BIBusEnvelope generateFault(MessageContext mc) {
        Locale locale = (Locale)mc.getProperty("locale");
        if (locale == null) {
            locale = new Locale("en");
        }
        BIBusEnvelope responseEnvelope = this.buildResponseEnvelopeStub(mc);
        if (this.getFault() == FaultType.REQUEST_ERROR) {
            Element faultElement = responseEnvelope.createFaultElement(CLIENT_FAULT, this.getUserLocaleMessage(locale));
        } else {
            Element faultElement = responseEnvelope.createFaultElement(SERVER_FAULT, this.getUserLocaleMessage(locale));
        }
        Element detail = responseEnvelope.getFaultDetail();
        this.generateDetails(detail, locale);
        return responseEnvelope;
    }

    private BIBusEnvelope buildResponseEnvelopeStub(MessageContext mc) {
        BIBusEnvelope responseEnvelope;
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        if (requestEnvelope == null) {
            responseEnvelope = new BIBusEnvelope();
        } else {
            Element headerElement = requestEnvelope.getHeader();
            headerElement.detach();
            responseEnvelope = new BIBusEnvelope(headerElement);
        }
        Element camProtect = requestEnvelope.getCAMProtect();
        if (camProtect != null) {
            camProtect.detach();
        }
        return responseEnvelope;
    }

    public static enum FaultType {
        REQUEST_ERROR("400"),
        FORBIDDEN("403"),
        NO_OBJECT("404"),
        SERVER_ERROR("500");

        private String errorCode;

        private FaultType(String errorCode) {
            this.errorCode = errorCode;
        }

        public String errorCode() {
            return this.errorCode;
        }
    }
}

