/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.i18n;

import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import com.ibm.cognos.internal.annotations.i18n.MessageResourceProvider;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class BundledMessageResources
implements MessageResourceProvider {
    static String bundleName = "ansmsg";

    @Override
    public String getServerLocaleResMessage(AnnotationI18NCode code, Object[] parms) {
        String serverLocaleString = null;
        try {
            serverLocaleString = this.getProperties().getProperty("serverLocale");
        }
        catch (PropertiesException propertiesException) {
            // empty catch block
        }
        return this.getResMessage(code, parms, new Locale(serverLocaleString));
    }

    @Override
    public String getServerLocaleResMessage(AnnotationI18NCode code) {
        String serverLocaleString = null;
        try {
            serverLocaleString = this.getProperties().getProperty("serverLocale");
        }
        catch (PropertiesException propertiesException) {
            // empty catch block
        }
        return this.getResMessage(code, new Locale(serverLocaleString));
    }

    @Override
    public String getResMessage(AnnotationI18NCode code, Locale locale) {
        try {
            return this.getBundle(locale).getString(code.getKey());
        }
        catch (Exception e) {
            return code.getKey();
        }
    }

    @Override
    public String getResMessage(AnnotationI18NCode code, Object[] parms, Locale locale) {
        try {
            Object[] localizedParms = this.getLocalizedParams(locale, parms);
            return MessageFormat.format(this.getBundle(locale).getString(code.getKey()), localizedParms);
        }
        catch (Exception e) {
            return code.getKey();
        }
    }

    protected ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("ansmsg", locale);
    }

    private Object[] getLocalizedParams(Locale locale, Object[] params) {
        if (params == null || params.length < 1) {
            return params;
        }
        Object[] result = new Object[params.length];
        String oneMsg = null;
        AnnotationI18NCode oneCode = null;
        for (int counter = 0; counter < params.length; ++counter) {
            if (params[counter] != null && params[counter] instanceof AnnotationI18NCode) {
                oneCode = (AnnotationI18NCode)params[counter];
                oneMsg = this.getResMessage(oneCode, locale);
                result[counter] = oneMsg;
                continue;
            }
            result[counter] = params[counter];
        }
        return result;
    }

    protected CRNProperties getProperties() {
        return CRNProperties.getInstance();
    }
}

