/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.metrics;

import com.ibm.cognos.internal.annotations.metrics.AnnotationPerfMBean;
import java.util.Date;

public class AnnotationPerfMBeanImpl
implements AnnotationPerfMBean {
    private long timeInAnnotationService = 0L;
    private long timeInCM = 0L;
    private long timeInOpenJPA = 0L;
    private long annotationServiceRequestCount = 0L;
    private long cmRequestCount = 0L;
    private long openJPARequestCount = 0L;
    private static AnnotationPerfMBeanImpl m_instance = new AnnotationPerfMBeanImpl();

    private AnnotationPerfMBeanImpl() {
    }

    public static AnnotationPerfMBeanImpl getInstance() {
        return m_instance;
    }

    @Override
    public long getTimeInAnnotationService() {
        return this.timeInAnnotationService;
    }

    @Override
    public long getTimeInCM() {
        return this.timeInCM;
    }

    @Override
    public long getTimeInOpenJPA() {
        return this.timeInOpenJPA;
    }

    @Override
    public long getAnnotationServiceRequestCount() {
        return this.annotationServiceRequestCount;
    }

    @Override
    public long getCMRequestCount() {
        return this.cmRequestCount;
    }

    @Override
    public long getOpenJPARequestCount() {
        return this.openJPARequestCount;
    }

    @Override
    public void reset() {
        this.timeInAnnotationService = 0L;
        this.timeInCM = 0L;
        this.timeInOpenJPA = 0L;
        this.annotationServiceRequestCount = 0L;
        this.cmRequestCount = 0L;
        this.openJPARequestCount = 0L;
    }

    public void updateTimeInAnnotationService(Date start, Date end) {
        this.timeInAnnotationService += end.getTime() - start.getTime();
    }

    public void updateTimeInCM(Date start, Date end) {
        this.timeInCM += end.getTime() - start.getTime();
    }

    public void updateTimeInOpenJPA(Date start, Date end) {
        this.timeInOpenJPA += end.getTime() - start.getTime();
    }

    public void incrementAnnotationServiceRequestCount() {
        ++this.annotationServiceRequestCount;
    }

    public void incrementCmRequestCount() {
        ++this.cmRequestCount;
    }

    public void incrementOpenJPARequestCount() {
        ++this.openJPARequestCount;
    }
}

