/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.persist;

import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import com.ibm.cognos.internal.annotations.persist.PersistResult;
import com.ibm.cognos.internal.annotations.persist.Persistor;
import com.ibm.cognos.internal.annotations.persist.PersistorContextImpl;
import com.ibm.cognos.internal.annotations.persist.PersistorFactory;
import com.ibm.cognos.internal.annotations.pojos.Context;
import com.ibm.cognos.internal.annotations.pojos.Dimension;
import com.ibm.cognos.internal.annotations.pojos.DimensionMember;
import com.ibm.cognos.internal.annotations.pojos.Model;
import com.ibm.cognos.internal.annotations.query.Query;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ContextPersistor
implements Persistor {
    private Context context;
    private PersistorFactory factory;
    private PersistorContextImpl persistContext;

    public ContextPersistor(Context context, PersistorFactory factory, PersistorContextImpl persistContext) {
        this.context = context;
        this.factory = factory;
        this.persistContext = persistContext;
        this.context.setId(0L);
    }

    @Override
    public void setObjectToPersist(Object obj) {
        this.context = (Context)obj;
    }

    @Override
    public PersistResult persist() throws AnnotationServiceException {
        PersistResult persistedContextResult = new PersistResult();
        persistedContextResult.setFound(true);
        PersistResult persistedDimensionMembers = this.persistDimensionMembers();
        this.context.setDimensionMembers((List)persistedDimensionMembers.getPersistedObject());
        persistedContextResult.addChild(persistedDimensionMembers);
        if (persistedContextResult.isFound()) {
            Query contextQuery = this.persistContext.getQueryFactory().getQuery(this.context);
            List foundContexts = contextQuery.getResults(this.persistContext.getEntityManager());
            if (foundContexts.size() > 1) {
                throw new AnnotationServiceException(AnnotationI18NCode.INCONSISTENCY_IN_CONTEXT_TABLE);
            }
            if (foundContexts.isEmpty()) {
                persistedContextResult.setFound(false);
                persistedContextResult.setPersistedObject(this.context);
            } else {
                persistedContextResult.setFound(true);
                persistedContextResult.setPersistedObject(foundContexts.get(0));
            }
        } else {
            persistedContextResult.setFound(false);
            persistedContextResult.setPersistedObject(this.context);
        }
        PersistResult persistedModel = this.persistModel();
        persistedContextResult.addChild(persistedModel);
        return persistedContextResult;
    }

    private PersistResult persistDimensionMembers() throws AnnotationServiceException {
        PersistResult persistedDimensionMembersResult = new PersistResult();
        ArrayList<DimensionMember> persistedDimensionMembers = new ArrayList<DimensionMember>();
        persistedDimensionMembersResult.dontCount();
        persistedDimensionMembersResult.setPersistedObject(persistedDimensionMembers);
        Iterator<DimensionMember> dimensionMemberIt = this.context.getDimensionMembers().iterator();
        while (dimensionMemberIt.hasNext()) {
            Persistor dimensionMemberPersistor = this.factory.getPersistor(dimensionMemberIt.next(), this.persistContext);
            PersistResult persistedDimensionMember = dimensionMemberPersistor.persist();
            persistedDimensionMembers.add((DimensionMember)persistedDimensionMember.getPersistedObject());
            persistedDimensionMembersResult.addChild(persistedDimensionMember);
        }
        return persistedDimensionMembersResult;
    }

    private PersistResult persistModel() throws AnnotationServiceException {
        PersistResult persistedModel = new PersistResult();
        boolean found = true;
        Iterator<PersistResult> it = this.persistContext.getDimensionResults().iterator();
        ArrayList<Dimension> dimensionList = new ArrayList<Dimension>();
        while (it.hasNext()) {
            PersistResult dimensionResult = it.next();
            found = found && dimensionResult.isFound();
            dimensionList.add((Dimension)dimensionResult.getPersistedObject());
        }
        Model templateModel = new Model();
        templateModel.setDimensions(dimensionList);
        if (found) {
            Query modelQuery = this.persistContext.getQueryFactory().getQuery(templateModel);
            List foundModels = modelQuery.getResults(this.persistContext.getEntityManager());
            if (foundModels.size() > 1) {
                throw new AnnotationServiceException(AnnotationI18NCode.INCONSISTENCY_IN_MODEL_TABLE);
            }
            if (foundModels.isEmpty()) {
                persistedModel.setPersistedObject(templateModel);
                persistedModel.setFound(false);
            } else {
                persistedModel.setPersistedObject(foundModels.get(0));
                persistedModel.setFound(true);
            }
        } else {
            persistedModel.setPersistedObject(templateModel);
            persistedModel.setFound(false);
        }
        return persistedModel;
    }
}

