/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.persist;

import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import com.ibm.cognos.internal.annotations.persist.PersistResult;
import com.ibm.cognos.internal.annotations.persist.Persistor;
import com.ibm.cognos.internal.annotations.persist.PersistorContextImpl;
import com.ibm.cognos.internal.annotations.persist.PersistorFactory;
import com.ibm.cognos.internal.annotations.pojos.DataItem;
import com.ibm.cognos.internal.annotations.query.Query;
import java.util.List;

public class DataItemPersistor
implements Persistor {
    private DataItem dataItem;
    private PersistorFactory factory;
    private PersistorContextImpl context;

    public DataItemPersistor(DataItem dataItem, PersistorFactory factory, PersistorContextImpl context) {
        this.dataItem = dataItem;
        this.factory = factory;
        this.context = context;
        this.dataItem.setId(0L);
    }

    @Override
    public void setObjectToPersist(Object obj) {
        this.dataItem = (DataItem)obj;
    }

    @Override
    public PersistResult persist() throws AnnotationServiceException {
        PersistResult persistedDataItem = new PersistResult();
        Query dataItemQuery = this.context.getQueryFactory().getQuery(this.dataItem);
        List foundDataItems = dataItemQuery.getResults(this.context.getEntityManager());
        if (foundDataItems.size() > 1) {
            throw new AnnotationServiceException(AnnotationI18NCode.INCONSISTENCY_IN_DATAITEM_TABLE);
        }
        if (foundDataItems.isEmpty()) {
            persistedDataItem.setFound(false);
            DataItem newDataItem = this.context.mapDataItem(this.dataItem);
            persistedDataItem.setPersistedObject(newDataItem);
        } else {
            persistedDataItem.setFound(true);
            persistedDataItem.setPersistedObject(foundDataItems.get(0));
        }
        return persistedDataItem;
    }
}

