/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.persist;

import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import com.ibm.cognos.internal.annotations.persist.PersistResult;
import com.ibm.cognos.internal.annotations.persist.Persistor;
import com.ibm.cognos.internal.annotations.persist.PersistorContextImpl;
import com.ibm.cognos.internal.annotations.persist.PersistorFactory;
import com.ibm.cognos.internal.annotations.pojos.DataItem;
import com.ibm.cognos.internal.annotations.pojos.Dimension;
import com.ibm.cognos.internal.annotations.pojos.DimensionMember;
import com.ibm.cognos.internal.annotations.query.Query;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DimensionMemberPersistor
implements Persistor {
    private DimensionMember dimensionMember;
    private PersistorFactory factory;
    private PersistorContextImpl context;

    public DimensionMemberPersistor(DimensionMember dimensionMember, PersistorFactory factory, PersistorContextImpl context) {
        this.dimensionMember = dimensionMember;
        this.factory = factory;
        this.context = context;
        this.dimensionMember.setId(0L);
    }

    @Override
    public void setObjectToPersist(Object obj) {
        this.dimensionMember = (DimensionMember)obj;
    }

    @Override
    public PersistResult persist() throws AnnotationServiceException {
        PersistResult persistedDimensionMemberResult = new PersistResult();
        persistedDimensionMemberResult.setFound(true);
        Persistor dimensionPersistor = this.factory.getPersistor(this.dimensionMember.getDimension(), this.context);
        PersistResult persistedDimension = dimensionPersistor.persist();
        this.dimensionMember.setDimension((Dimension)persistedDimension.getPersistedObject());
        persistedDimensionMemberResult.addChild(persistedDimension);
        PersistResult persistedDataItems = this.persistDataItems();
        this.dimensionMember.setDataItems((List)persistedDataItems.getPersistedObject());
        persistedDimensionMemberResult.addChild(persistedDataItems);
        if (persistedDimensionMemberResult.isFound()) {
            Query dimensionMemberQuery = this.context.getQueryFactory().getQuery(this.dimensionMember);
            List foundDimensionMembers = dimensionMemberQuery.getResults(this.context.getEntityManager());
            if (foundDimensionMembers.size() > 1) {
                throw new AnnotationServiceException(AnnotationI18NCode.INCONSISTENCY_IN_DIMENSIONMEMBER_TABLE);
            }
            if (foundDimensionMembers.isEmpty()) {
                persistedDimensionMemberResult.setPersistedObject(this.dimensionMember);
                persistedDimensionMemberResult.setFound(false);
            } else {
                persistedDimensionMemberResult.setPersistedObject(foundDimensionMembers.get(0));
                persistedDimensionMemberResult.setFound(true);
            }
        } else {
            persistedDimensionMemberResult.setPersistedObject(this.dimensionMember);
            persistedDimensionMemberResult.setFound(false);
        }
        return persistedDimensionMemberResult;
    }

    private PersistResult persistDataItems() throws AnnotationServiceException {
        PersistResult persistedDataItemsResult = new PersistResult();
        ArrayList<DataItem> persistedDataItems = new ArrayList<DataItem>();
        persistedDataItemsResult.dontCount();
        persistedDataItemsResult.setPersistedObject(persistedDataItems);
        Iterator<DataItem> dataItemIt = this.dimensionMember.getDataItems().iterator();
        while (dataItemIt.hasNext()) {
            Persistor dataItemPersistor = this.factory.getPersistor(dataItemIt.next(), this.context);
            PersistResult persistedDataItem = dataItemPersistor.persist();
            persistedDataItems.add((DataItem)persistedDataItem.getPersistedObject());
            persistedDataItemsResult.addChild(persistedDataItem);
        }
        return persistedDataItemsResult;
    }
}

