/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.persist;

import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import com.ibm.cognos.internal.annotations.persist.PersistResult;
import com.ibm.cognos.internal.annotations.persist.Persistor;
import com.ibm.cognos.internal.annotations.persist.PersistorContextImpl;
import com.ibm.cognos.internal.annotations.persist.PersistorFactory;
import com.ibm.cognos.internal.annotations.pojos.Dimension;
import com.ibm.cognos.internal.annotations.pojos.MetadataItem;
import com.ibm.cognos.internal.annotations.query.Query;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DimensionPersistor
implements Persistor {
    private Dimension dimension;
    private PersistorFactory factory;
    private PersistorContextImpl context;

    public DimensionPersistor(Dimension dimension, PersistorFactory factory, PersistorContextImpl context) {
        this.dimension = dimension;
        this.factory = factory;
        this.context = context;
        this.dimension.setId(0L);
    }

    @Override
    public void setObjectToPersist(Object obj) {
        this.dimension = (Dimension)obj;
    }

    @Override
    public PersistResult persist() throws AnnotationServiceException {
        PersistResult persistedDimensionResult = new PersistResult();
        PersistResult persistedMetadataItemsResult = this.persistMetadataItems();
        persistedDimensionResult.addChild(persistedMetadataItemsResult);
        this.dimension.setMetadataItems((List)persistedMetadataItemsResult.getPersistedObject());
        if (persistedMetadataItemsResult.isFound()) {
            Query dimensionQuery = this.context.getQueryFactory().getQuery(this.dimension);
            List persistedDimensions = dimensionQuery.getResults(this.context.getEntityManager());
            if (persistedDimensions.size() > 1) {
                throw new AnnotationServiceException(AnnotationI18NCode.INCONSISTENCY_IN_DIMENSION_TABLE);
            }
            if (persistedDimensions.isEmpty()) {
                persistedDimensionResult.setFound(false);
                persistedDimensionResult.setPersistedObject(this.dimension);
            } else {
                persistedDimensionResult.setFound(true);
                persistedDimensionResult.setPersistedObject(persistedDimensions.get(0));
            }
        } else {
            persistedDimensionResult.setFound(false);
            persistedDimensionResult.setPersistedObject(this.dimension);
        }
        this.context.addToDimensionResults(persistedDimensionResult);
        return persistedDimensionResult;
    }

    private PersistResult persistMetadataItems() throws AnnotationServiceException {
        PersistResult persistedMetadateItemsResult = new PersistResult();
        ArrayList<MetadataItem> persistedMetadataItems = new ArrayList<MetadataItem>();
        persistedMetadateItemsResult.dontCount();
        persistedMetadateItemsResult.setPersistedObject(persistedMetadataItems);
        Iterator<MetadataItem> metadataItemIt = this.dimension.getMetadataItems().iterator();
        while (metadataItemIt.hasNext()) {
            Persistor metadataItemPersistor = this.factory.getPersistor(metadataItemIt.next(), this.context);
            PersistResult persistedMetadataItem = metadataItemPersistor.persist();
            persistedMetadataItems.add((MetadataItem)persistedMetadataItem.getPersistedObject());
            persistedMetadateItemsResult.addChild(persistedMetadataItem);
        }
        return persistedMetadateItemsResult;
    }
}

