/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.persist;

import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import com.ibm.cognos.internal.annotations.persist.PersistResult;
import com.ibm.cognos.internal.annotations.persist.Persistor;
import com.ibm.cognos.internal.annotations.persist.PersistorContextImpl;
import com.ibm.cognos.internal.annotations.persist.PersistorFactory;
import com.ibm.cognos.internal.annotations.pojos.MetadataItem;
import com.ibm.cognos.internal.annotations.query.Query;
import java.util.List;

public class MetadataItemPersistor
implements Persistor {
    private MetadataItem metadataItem;
    private PersistorFactory factory;
    private PersistorContextImpl context;

    public MetadataItemPersistor(MetadataItem metadataItem, PersistorFactory factory, PersistorContextImpl context) {
        this.metadataItem = metadataItem;
        this.factory = factory;
        this.context = context;
        this.metadataItem.setId(0L);
    }

    @Override
    public void setObjectToPersist(Object obj) {
        this.metadataItem = (MetadataItem)obj;
    }

    @Override
    public PersistResult persist() throws AnnotationServiceException {
        PersistResult persistedMetadataItem = new PersistResult();
        Query metadataItemQuery = this.context.getQueryFactory().getQuery(this.metadataItem);
        List foundMetadataItems = metadataItemQuery.getResults(this.context.getEntityManager());
        if (foundMetadataItems.size() > 1) {
            throw new AnnotationServiceException(AnnotationI18NCode.INCONSISTENCY_IN_METADATAITEM_TABLE);
        }
        if (foundMetadataItems.isEmpty()) {
            persistedMetadataItem.setFound(false);
            MetadataItem newMetadataItem = this.context.mapMetadataItem(this.metadataItem);
            persistedMetadataItem.setPersistedObject(newMetadataItem);
        } else {
            persistedMetadataItem.setFound(true);
            persistedMetadataItem.setPersistedObject(foundMetadataItems.get(0));
        }
        return persistedMetadataItem;
    }
}

