/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.persist;

import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import com.ibm.cognos.internal.annotations.persist.PersistResult;
import com.ibm.cognos.internal.annotations.persist.PersistorContext;
import com.ibm.cognos.internal.annotations.pojos.Annotation;
import com.ibm.cognos.internal.annotations.pojos.Context;
import com.ibm.cognos.internal.annotations.pojos.DataItem;
import com.ibm.cognos.internal.annotations.pojos.Dimension;
import com.ibm.cognos.internal.annotations.pojos.DimensionMember;
import com.ibm.cognos.internal.annotations.pojos.MetadataItem;
import com.ibm.cognos.internal.annotations.pojos.Model;
import com.ibm.cognos.internal.annotations.query.QueryFactory;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;

public class PersistorContextImpl
implements PersistorContext {
    private QueryFactory queryFactory;
    private EntityManager em;
    private List<Object> itemsToPersist;
    private List<Object> itemsAlreadyPersisted;
    private List<PersistResult> dimensionsResults = new ArrayList<PersistResult>();
    private Hashtable<DataItem, DataItem> newDataItems = new Hashtable();
    private Hashtable<MetadataItem, MetadataItem> newMetadataItems = new Hashtable();

    public PersistorContextImpl(QueryFactory queryFactory, EntityManager entityManager) {
        this.queryFactory = queryFactory;
        this.em = entityManager;
    }

    @Override
    public void persist(PersistResult finalResult) throws AnnotationServiceException {
        this.itemsToPersist = new ArrayList<Object>();
        this.itemsAlreadyPersisted = new ArrayList<Object>();
        finalResult.collectFoundItems(this.itemsAlreadyPersisted);
        finalResult.collectNonFoundItems(this.itemsToPersist);
        this.itemsToPersist = this.sortItems(this.itemsToPersist);
        EntityTransaction transaction = this.em.getTransaction();
        try {
            transaction.begin();
            for (Object nonPersistedItem : this.itemsToPersist) {
                this.em.persist(nonPersistedItem);
            }
            for (Object persistedItem : this.itemsAlreadyPersisted) {
                if (this.em.contains(persistedItem)) continue;
                this.em.merge(persistedItem);
            }
            transaction.commit();
        }
        catch (Throwable t) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            if (t instanceof AnnotationServiceException) {
                throw (AnnotationServiceException)t;
            }
            throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_GENERAL_ERROR, t);
        }
    }

    private List<Object> sortItems(List<Object> items) throws AnnotationServiceException {
        ArrayList<Object> returnedItems = new ArrayList<Object>();
        Class[] classOrder = new Class[]{DataItem.class, MetadataItem.class, Dimension.class, DimensionMember.class, Model.class, Context.class, Annotation.class};
        for (int i = 0; i < classOrder.length; ++i) {
            for (int j = 0; j < items.size(); ++j) {
                if (!items.get(j).getClass().equals(classOrder[i])) continue;
                returnedItems.add(items.get(j));
            }
        }
        if (returnedItems.size() != items.size()) {
            throw new AnnotationServiceException(AnnotationI18NCode.PERSISTOR_WRONG_SORT_ORDER, new Object[]{"" + items.size(), "" + returnedItems.size()});
        }
        return returnedItems;
    }

    DataItem mapDataItem(DataItem dataItem) {
        if (this.newDataItems.containsKey(dataItem)) {
            return this.newDataItems.get(dataItem);
        }
        this.newDataItems.put(dataItem, dataItem);
        return dataItem;
    }

    MetadataItem mapMetadataItem(MetadataItem metadataItem) {
        if (this.newMetadataItems.containsKey(metadataItem)) {
            return this.newMetadataItems.get(metadataItem);
        }
        this.newMetadataItems.put(metadataItem, metadataItem);
        return metadataItem;
    }

    void addToDimensionResults(PersistResult result) {
        this.dimensionsResults.add(result);
    }

    List<PersistResult> getDimensionResults() {
        return this.dimensionsResults;
    }

    List<Object> getItemsToPersist() {
        return this.itemsToPersist;
    }

    List<Object> getItemsAlreadyPersisted() {
        return this.itemsAlreadyPersisted;
    }

    QueryFactory getQueryFactory() {
        return this.queryFactory;
    }

    EntityManager getEntityManager() {
        return this.em;
    }
}

