/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.persist;

import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import com.ibm.cognos.internal.annotations.persist.AnnotationPersistor;
import com.ibm.cognos.internal.annotations.persist.ContextPersistor;
import com.ibm.cognos.internal.annotations.persist.DataItemPersistor;
import com.ibm.cognos.internal.annotations.persist.DimensionMemberPersistor;
import com.ibm.cognos.internal.annotations.persist.DimensionPersistor;
import com.ibm.cognos.internal.annotations.persist.MetadataItemPersistor;
import com.ibm.cognos.internal.annotations.persist.Persistor;
import com.ibm.cognos.internal.annotations.persist.PersistorContext;
import com.ibm.cognos.internal.annotations.pojos.Annotation;
import com.ibm.cognos.internal.annotations.pojos.Context;
import com.ibm.cognos.internal.annotations.pojos.DataItem;
import com.ibm.cognos.internal.annotations.pojos.Dimension;
import com.ibm.cognos.internal.annotations.pojos.DimensionMember;
import com.ibm.cognos.internal.annotations.pojos.MetadataItem;
import java.lang.reflect.Constructor;
import java.util.Hashtable;

public class PersistorFactory {
    Hashtable<Class, Class<? extends Persistor>> persistorMap = new Hashtable();
    Hashtable<Class, Persistor> persistorMapOverrides = new Hashtable();

    public PersistorFactory() {
        this.persistorMap.put(Annotation.class, AnnotationPersistor.class);
        this.persistorMap.put(Context.class, ContextPersistor.class);
        this.persistorMap.put(DataItem.class, DataItemPersistor.class);
        this.persistorMap.put(DimensionMember.class, DimensionMemberPersistor.class);
        this.persistorMap.put(MetadataItem.class, MetadataItemPersistor.class);
        this.persistorMap.put(Dimension.class, DimensionPersistor.class);
    }

    public Persistor getPersistor(Object objConvert, PersistorContext context) throws AnnotationServiceException {
        Persistor persistor = null;
        Persistor override = this.persistorMapOverrides.get(objConvert.getClass());
        if (override != null) {
            persistor = override;
            persistor.setObjectToPersist(objConvert);
        } else {
            Class<? extends Persistor> persistorClass = this.persistorMap.get(objConvert.getClass());
            if (persistorClass != null) {
                try {
                    Constructor<? extends Persistor> constructor = persistorClass.getConstructor(objConvert.getClass(), this.getClass(), context.getClass());
                    persistor = constructor.newInstance(objConvert, this, context);
                }
                catch (Exception e) {
                    throw new AnnotationServiceException(AnnotationI18NCode.PERSISTOR_CONSTRUCTOR_ERROR, new Object[]{objConvert.getClass().getName()}, e);
                }
            } else {
                throw new AnnotationServiceException(AnnotationI18NCode.PERSISTOR_NOT_FOUND, new Object[]{objConvert.getClass().getName()});
            }
        }
        return persistor;
    }

    public void addPersistor(Class classToPersist, Class<? extends Persistor> persistor) {
        this.persistorMap.put(classToPersist, persistor);
    }

    public void addPersistorOverride(Class classToPersist, Persistor persistor) {
        this.persistorMapOverrides.put(classToPersist, persistor);
    }
}

