/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.pojos;

import com.ibm.cognos.internal.hts.deployment.id.IdStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.openjpa.jdbc.meta.ClassMapping;

public class CompositeIdUtil {
    public static String composeCompositeKey(long[] idArray) {
        String compositeID = "";
        Arrays.sort(idArray);
        String padding = "0000000000000000";
        for (int i = 0; i < idArray.length; ++i) {
            String idPart = Long.toHexString(idArray[i]);
            if (idPart.length() < 16) {
                compositeID = compositeID + padding.substring(0, 16 - idPart.length());
                compositeID = compositeID + idPart;
                continue;
            }
            compositeID = compositeID + idPart;
        }
        return compositeID;
    }

    public static long[] decomposeCompositeKey(String compostiteId) {
        return CompositeIdUtil.decomposeCompositeKeyWithReplacedIds(compostiteId, null, null);
    }

    public static long[] decomposeCompositeKeyWithReplacedIds(String compostiteId, ClassMapping mapping, IdStrategy idStrat) {
        String idCopy = compostiteId;
        ArrayList<String> ids = new ArrayList<String>();
        while (idCopy.length() > 0) {
            String subId = idCopy.substring(0, 16);
            ids.add(subId);
            idCopy = idCopy.substring(16, idCopy.length());
        }
        long[] idLongs = new long[ids.size()];
        for (int i = 0; i < idLongs.length; ++i) {
            String replacedId;
            String id = (String)ids.get(i);
            if (idStrat != null && (replacedId = (String)idStrat.getPersistedEquivalentId(id, mapping)) != null) {
                id = replacedId;
            }
            idLongs[i] = Long.valueOf(id, 16);
        }
        return idLongs;
    }
}

