/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.query;

import com.ibm.cognos.internal.annotations.pojos.Annotation;
import com.ibm.cognos.internal.annotations.query.ContextQuery;
import com.ibm.cognos.internal.annotations.query.Query;
import com.ibm.cognos.internal.annotations.query.QueryBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TemporalType;

public class AnnotationQuery
implements Query {
    private List<Annotation> annotations = new ArrayList<Annotation>();
    private ContextQuery contextQuery;
    private Annotation examplar;

    public AnnotationQuery(Annotation annotation, boolean forceFind) {
        if (!forceFind && annotation.getId() != 0L) {
            this.annotations.add(annotation);
        }
        if (annotation.getContext() != null) {
            this.contextQuery = new ContextQuery(annotation.getContext());
        }
        this.examplar = annotation;
    }

    public AnnotationQuery(Annotation annotation) {
        this(annotation, false);
    }

    @Override
    public List<Annotation> getResults(EntityManager em) {
        javax.persistence.Query query;
        List queryResults;
        Iterator it;
        if (this.annotations.isEmpty() && (it = (queryResults = (query = this.generateJPQLQuery(em)).getResultList()).iterator()).hasNext()) {
            this.annotations = new ArrayList<Annotation>();
            while (it.hasNext()) {
                this.annotations.add((Annotation)it.next());
            }
        }
        return this.annotations;
    }

    @Override
    public void clear() {
        this.annotations.clear();
        if (this.contextQuery != null) {
            this.contextQuery.clear();
        }
    }

    javax.persistence.Query generateJPQLQuery(EntityManager em) {
        javax.persistence.Query query = null;
        String context_identifier = "context";
        String selectClause = "select annotation from Annotation annotation join annotation.text text";
        String whereClause = " where ";
        QueryBuilder queryBuilder = new QueryBuilder();
        queryBuilder.addToSelectStatement(selectClause);
        queryBuilder.addToWhereClause(whereClause);
        if (this.contextQuery != null) {
            queryBuilder.addToSelectStatement(" join annotation.context " + context_identifier);
        }
        if (this.examplar.getParentId() != null) {
            queryBuilder.addToWhereClause("annotation.parentId = :parentId ");
            queryBuilder.setParameter("parentId", this.examplar.getParentId());
        } else {
            queryBuilder.addToWhereClause("annotation.parentId is null ");
        }
        if (this.examplar.getSecondaryParentId() != null) {
            queryBuilder.addToWhereClause("and annotation.secondaryParentId = :secondaryParentId ");
            queryBuilder.setParameter("secondaryParentId", this.examplar.getSecondaryParentId());
        } else {
            queryBuilder.addToWhereClause("and annotation.secondaryParentId is null ");
        }
        if (this.examplar.getLocale() != null) {
            queryBuilder.addToWhereClause("and annotation.locale = :locale ");
            queryBuilder.setParameter("locale", this.examplar.getLocale());
        } else {
            queryBuilder.addToWhereClause("and annotation.locale is null ");
        }
        if (this.examplar.getText().getName() != null) {
            queryBuilder.addToWhereClause("and text.name = :name ");
            queryBuilder.setParameter("name", this.examplar.getText().getName());
        } else {
            queryBuilder.addToWhereClause("and text.name is null ");
        }
        if (this.examplar.getText().getDescription() != null) {
            queryBuilder.addToWhereClause("and text.description = :description ");
            queryBuilder.setParameter("description", this.examplar.getText().getDescription());
        } else {
            queryBuilder.addToWhereClause("and text.description is null ");
        }
        if (this.examplar.getOwner() != null) {
            queryBuilder.addToWhereClause("and annotation.owner = :owner ");
            queryBuilder.setParameter("owner", this.examplar.getOwner());
        } else {
            queryBuilder.addToWhereClause("and annotation.owner is null ");
        }
        if (this.examplar.getCreationTime() != null) {
            queryBuilder.addToWhereClause("and annotation.creationTime = :creationtime ");
            queryBuilder.setParameter("creationtime", this.examplar.getCreationTime(), TemporalType.DATE);
        } else {
            queryBuilder.addToWhereClause("and annotation.creationTime is null ");
        }
        if (this.examplar.getLastModificationTime() != null) {
            queryBuilder.addToWhereClause("and annotation.lastModificationTime = :lastModTime ");
            queryBuilder.setParameter("lastModTime", this.examplar.getLastModificationTime(), TemporalType.DATE);
        } else {
            queryBuilder.addToWhereClause("and annotation.lastModificationTime is null ");
        }
        if (this.contextQuery != null) {
            queryBuilder.addToWhereClause("and " + this.contextQuery.generateJPQLWhereClause(context_identifier, em));
        }
        query = queryBuilder.buildQuery(em);
        return query;
    }
}

