/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.query;

import com.ibm.cognos.internal.annotations.pojos.CompositeIdUtil;
import com.ibm.cognos.internal.annotations.pojos.Context;
import com.ibm.cognos.internal.annotations.query.DimensionMemberQuery;
import com.ibm.cognos.internal.annotations.query.Query;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;

public class ContextQuery
implements Query {
    private List<Context> contexts = new ArrayList<Context>();
    private List<DimensionMemberQuery> dimensionMemberQueries;

    public ContextQuery(Context context, boolean forceFind) {
        if (!forceFind && context.getId() != 0L) {
            this.contexts.add(context);
        }
        this.dimensionMemberQueries = DimensionMemberQuery.convert(context.getDimensionMembers());
    }

    public ContextQuery(Context context) {
        this(context, false);
    }

    public ContextQuery(List<DimensionMemberQuery> dimensionMemberQueries) {
        this.dimensionMemberQueries = dimensionMemberQueries;
    }

    String generateJPQLWithKey(EntityManager em) {
        String selectClause = "select context from Context context";
        String compositeId = "";
        long[] arrayIds = new long[this.dimensionMemberQueries.size()];
        for (int i = 0; i < this.dimensionMemberQueries.size(); ++i) {
            arrayIds[i] = this.dimensionMemberQueries.get(i).getResults(em).get(0).getId();
        }
        compositeId = CompositeIdUtil.composeCompositeKey(arrayIds);
        String whereClause = " where context.compID = '" + compositeId + "'";
        return selectClause + whereClause;
    }

    String generateJPQL(EntityManager em) {
        int propertyId = 0;
        String selectClause = "select context from Context context";
        String whereClause = " where ";
        Iterator<DimensionMemberQuery> it = this.dimensionMemberQueries.iterator();
        while (it.hasNext()) {
            DimensionMemberQuery dimensionMemberQuery = it.next();
            String dimMember_identifier = "dimMem" + propertyId;
            selectClause = selectClause + " join context.dimensionMembers " + dimMember_identifier;
            whereClause = whereClause + dimensionMemberQuery.generateJPQLWhereClause(dimMember_identifier, em);
            if (it.hasNext()) {
                whereClause = whereClause + " and ";
            }
            ++propertyId;
        }
        return selectClause + whereClause;
    }

    @Override
    public List<Context> getResults(EntityManager em) {
        javax.persistence.Query query;
        List queryResults;
        Iterator it;
        if (this.contexts.isEmpty() && (it = (queryResults = (query = em.createQuery(this.generateJPQLWithKey(em))).getResultList()).iterator()).hasNext()) {
            this.contexts = new ArrayList<Context>();
            while (it.hasNext()) {
                this.contexts.add((Context)it.next());
            }
        }
        return this.contexts;
    }

    @Override
    public void clear() {
        this.contexts.clear();
        if (this.dimensionMemberQueries != null) {
            for (DimensionMemberQuery dimensionMemberQuery : this.dimensionMemberQueries) {
                dimensionMemberQuery.clear();
            }
        }
    }

    String generateJPQLWhereClause(String identifierVariable, EntityManager em) {
        StringBuffer jpql = new StringBuffer("");
        if (this.contexts.isEmpty()) {
            this.getResults(em);
        }
        if (this.contexts.size() == 1) {
            jpql.append(identifierVariable + ".id=" + this.contexts.get(0).getId() + "");
        } else {
            jpql.append(identifierVariable + ".id IN (");
            Iterator<Context> it = this.contexts.iterator();
            while (it.hasNext()) {
                Context value = it.next();
                jpql.append("" + value.getId() + "");
                if (!it.hasNext()) continue;
                jpql.append(",");
            }
            jpql.append(")");
        }
        return jpql.toString();
    }
}

