/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.query;

import com.ibm.cognos.internal.annotations.pojos.DataItem;
import com.ibm.cognos.internal.annotations.query.Query;
import com.ibm.cognos.internal.annotations.query.QueryBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;

public class DataItemQuery
implements Query {
    private List<DataItem> dataItems = new ArrayList<DataItem>();
    private String propertyName;
    private List<String> values = new ArrayList<String>();

    public DataItemQuery(DataItem dataItem, boolean forceFind) {
        if (!forceFind && dataItem.getId() != 0L) {
            this.dataItems.add(dataItem);
        }
        this.propertyName = dataItem.getName();
        this.values.add(dataItem.getValue());
    }

    public DataItemQuery(DataItem dataItem) {
        this(dataItem, false);
    }

    public DataItemQuery(String name, String value) {
        this.propertyName = name;
        if (value != null) {
            this.values.add(value);
        }
    }

    public DataItemQuery(String name, List<String> values) {
        this.propertyName = name;
        this.values.addAll(values);
    }

    public static List<DataItemQuery> convert(List<DataItem> dataItems) {
        ArrayList<DataItemQuery> queryList = new ArrayList<DataItemQuery>();
        for (DataItem dataItem : dataItems) {
            queryList.add(new DataItemQuery(dataItem));
        }
        return queryList;
    }

    @Override
    public List<DataItem> getResults(EntityManager em) {
        if (this.dataItems.isEmpty()) {
            javax.persistence.Query query = this.generateJPQL().buildQuery(em);
            List queryResults = query.getResultList();
            Iterator it = queryResults.iterator();
            while (it.hasNext()) {
                this.dataItems.add((DataItem)it.next());
            }
        }
        return this.dataItems;
    }

    @Override
    public void clear() {
        this.dataItems.clear();
    }

    QueryBuilder generateJPQL() {
        QueryBuilder queryBuilder = new QueryBuilder();
        String identificationVariable = "d1";
        queryBuilder.addToSelectStatement("select ");
        queryBuilder.addToSelectStatement(identificationVariable);
        queryBuilder.addToSelectStatement(" from DataItem ");
        queryBuilder.addToSelectStatement(identificationVariable);
        queryBuilder.addToWhereClause(" where ");
        this.generateJPQLWhereClause(queryBuilder, identificationVariable);
        return queryBuilder;
    }

    void generateJPQLWhereClause(QueryBuilder queryBuilder, String idVar) {
        if (this.dataItems.size() > 0) {
            if (this.dataItems.size() == 1) {
                queryBuilder.addToWhereClause(idVar + ".id=:dataItemId" + idVar);
                queryBuilder.setParameter("dataItemId" + idVar, this.dataItems.get(0).getId());
            } else {
                queryBuilder.addToWhereClause(idVar + ".id IN (:dataItemTokens" + idVar + ")");
                Iterator<DataItem> it = this.dataItems.iterator();
                ArrayList<Long> dataItemTokenArray = new ArrayList<Long>();
                while (it.hasNext()) {
                    DataItem item = it.next();
                    dataItemTokenArray.add(item.getId());
                }
                queryBuilder.setParameter("dataItemTokens" + idVar, dataItemTokenArray);
            }
        } else {
            if (this.propertyName != null) {
                queryBuilder.addToWhereClause(idVar + ".name=:propertyName" + idVar);
                queryBuilder.setParameter("propertyName" + idVar, this.propertyName);
                if (!this.values.isEmpty()) {
                    queryBuilder.addToWhereClause(" and ");
                }
            }
            if (this.values.size() == 1) {
                if (this.values.get(0).length() > 0) {
                    queryBuilder.addToWhereClause(idVar + ".value=:value" + idVar);
                    queryBuilder.setParameter("value" + idVar, this.values.get(0));
                } else {
                    queryBuilder.addToWhereClause(idVar + ".vE=:vEValue" + idVar);
                    queryBuilder.setParameter("vEValue" + idVar, DataItem.toShort(true));
                }
            } else {
                queryBuilder.addToWhereClause(idVar + ".value IN (:valueTokens" + idVar + ")");
                queryBuilder.setParameter("valueTokens" + idVar, this.values);
            }
        }
    }

    String getPropertyName() {
        return this.propertyName;
    }

    List<String> getValues() {
        return this.values;
    }
}

