/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.query;

import com.ibm.cognos.internal.annotations.pojos.CompositeIdUtil;
import com.ibm.cognos.internal.annotations.pojos.DimensionMember;
import com.ibm.cognos.internal.annotations.query.DataItemQuery;
import com.ibm.cognos.internal.annotations.query.DimensionQuery;
import com.ibm.cognos.internal.annotations.query.Query;
import com.ibm.cognos.internal.annotations.query.QueryBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;

public class DimensionMemberQuery
implements Query {
    private List<DimensionMember> dimensionMembers = new ArrayList<DimensionMember>();
    private DimensionQuery dimensionQuery;
    private List<DataItemQuery> dataItemQueries;

    public DimensionMemberQuery(DimensionMember dimensionMember, boolean forceFind) {
        if (!forceFind && dimensionMember.getId() != 0L) {
            this.dimensionMembers.add(dimensionMember);
        }
        if (dimensionMember.getDimension() != null) {
            this.dimensionQuery = new DimensionQuery(dimensionMember.getDimension());
        }
        if (dimensionMember.getDataItems() != null) {
            this.dataItemQueries = DataItemQuery.convert(dimensionMember.getDataItems());
        }
    }

    public DimensionMemberQuery(DimensionMember dimensionMember) {
        this(dimensionMember, false);
    }

    DimensionMemberQuery(List<DimensionMember> dimensionMembers) {
        this.dimensionMembers = dimensionMembers;
    }

    public DimensionMemberQuery(DimensionQuery dimensionQuery, List<DataItemQuery> dataItemQueries) {
        this.dimensionQuery = dimensionQuery;
        this.dataItemQueries = dataItemQueries;
    }

    public static List<DimensionMemberQuery> convert(List<DimensionMember> dimensionMembers) {
        ArrayList<DimensionMemberQuery> queryList = new ArrayList<DimensionMemberQuery>();
        for (DimensionMember dimensionMember : dimensionMembers) {
            queryList.add(new DimensionMemberQuery(dimensionMember));
        }
        return queryList;
    }

    @Override
    public List<DimensionMember> getResults(EntityManager em) {
        javax.persistence.Query query;
        List queryResults;
        Iterator it;
        if (this.dimensionMembers.isEmpty() && (it = (queryResults = (query = em.createQuery(this.generateJPQLWithKey(em))).getResultList()).iterator()).hasNext()) {
            this.dimensionMembers = new ArrayList<DimensionMember>();
            while (it.hasNext()) {
                this.dimensionMembers.add((DimensionMember)it.next());
            }
        }
        return this.dimensionMembers;
    }

    @Override
    public void clear() {
        this.dimensionMembers.clear();
        if (this.dimensionQuery != null) {
            this.dimensionQuery.clear();
        }
        if (this.dataItemQueries != null) {
            for (DataItemQuery dataItemQuery : this.dataItemQueries) {
                dataItemQuery.clear();
            }
        }
    }

    String generateJPQLWithKey(EntityManager em) {
        String selectClause = "select dimMem from DimensionMember dimMem";
        String compositeId = "";
        long[] arrayIds = new long[this.dataItemQueries.size()];
        for (int i = 0; i < this.dataItemQueries.size(); ++i) {
            arrayIds[i] = this.dataItemQueries.get(i).getResults(em).get(0).getId();
        }
        compositeId = CompositeIdUtil.composeCompositeKey(arrayIds);
        String whereClause = " where dimMem.compID = '" + compositeId + "'";
        whereClause = whereClause + " and ";
        whereClause = whereClause + this.dimensionQuery.generateJPQLWhereClause("dimMem.dimension", em);
        return selectClause + whereClause;
    }

    QueryBuilder generateJPQL(EntityManager em) {
        int propertyId = 0;
        QueryBuilder queryBuilder = new QueryBuilder();
        queryBuilder.addToSelectStatement("select dimMem from DimensionMember dimMem");
        queryBuilder.addToWhereClause(" where ");
        Iterator<DataItemQuery> it = this.dataItemQueries.iterator();
        while (it.hasNext()) {
            DataItemQuery dataItemQuery = it.next();
            String data_identifier = "dataItem" + propertyId;
            queryBuilder.addToSelectStatement(" join dimMem.dataItems " + data_identifier);
            dataItemQuery.generateJPQLWhereClause(queryBuilder, data_identifier);
            if (it.hasNext()) {
                queryBuilder.addToWhereClause(" and ");
            }
            ++propertyId;
        }
        queryBuilder.addToWhereClause(" and ");
        queryBuilder.addToWhereClause(this.dimensionQuery.generateJPQLWhereClause("dimMem.dimension", em));
        return queryBuilder;
    }

    String generateJPQLWhereClause(String identifierVariable, EntityManager em) {
        StringBuffer jpql = new StringBuffer("");
        if (this.dimensionMembers.isEmpty()) {
            this.getResults(em);
        }
        if (this.dimensionMembers.size() == 1) {
            jpql.append(identifierVariable + ".id=" + this.dimensionMembers.get(0).getId() + "");
        } else {
            jpql.append(identifierVariable + ".id IN (");
            Iterator<DimensionMember> it = this.dimensionMembers.iterator();
            while (it.hasNext()) {
                DimensionMember value = it.next();
                jpql.append("" + value.getId() + "");
                if (!it.hasNext()) continue;
                jpql.append(",");
            }
            jpql.append(")");
        }
        return jpql.toString();
    }
}

