/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.query;

import com.ibm.cognos.internal.annotations.pojos.CompositeIdUtil;
import com.ibm.cognos.internal.annotations.pojos.Dimension;
import com.ibm.cognos.internal.annotations.query.MetadataItemQuery;
import com.ibm.cognos.internal.annotations.query.Query;
import com.ibm.cognos.internal.annotations.query.QueryBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;

public class DimensionQuery
implements Query {
    List<Dimension> dimensions = new ArrayList<Dimension>();
    private List<MetadataItemQuery> metadataItemQueries;

    public DimensionQuery(Dimension dimension, boolean forceFind) {
        if (!forceFind && dimension.getId() != 0L) {
            this.dimensions.add(dimension);
        }
        this.metadataItemQueries = MetadataItemQuery.convert(dimension.getMetadataItems());
    }

    public DimensionQuery(Dimension dimension) {
        this(dimension, false);
    }

    public DimensionQuery(List<MetadataItemQuery> metadataItemQueries) {
        this.metadataItemQueries = metadataItemQueries;
    }

    public static List<DimensionQuery> convert(List<Dimension> dimensions) {
        ArrayList<DimensionQuery> queryList = new ArrayList<DimensionQuery>();
        Iterator<Dimension> it = dimensions.iterator();
        while (it.hasNext()) {
            queryList.add(new DimensionQuery(it.next()));
        }
        return queryList;
    }

    @Override
    public List<Dimension> getResults(EntityManager em) {
        javax.persistence.Query query;
        List queryResults;
        Iterator it;
        if (this.dimensions.isEmpty() && (it = (queryResults = (query = em.createQuery(this.generateJPQLWithKey(em))).getResultList()).iterator()).hasNext()) {
            this.dimensions.add((Dimension)it.next());
        }
        return this.dimensions;
    }

    @Override
    public void clear() {
        this.dimensions.clear();
        if (this.metadataItemQueries != null) {
            for (MetadataItemQuery metadataItemQuery : this.metadataItemQueries) {
                metadataItemQuery.clear();
            }
        }
    }

    String generateJPQLWithKey(EntityManager em) {
        String selectClause = "select dim from Dimension dim";
        String compositeKey = "";
        long[] arrayIds = new long[this.metadataItemQueries.size()];
        for (int i = 0; i < this.metadataItemQueries.size(); ++i) {
            arrayIds[i] = this.metadataItemQueries.get(i).getResults(em).get(0).getId();
        }
        compositeKey = CompositeIdUtil.composeCompositeKey(arrayIds);
        String whereClause = " where dim.compID = '" + compositeKey + "'";
        return selectClause + whereClause;
    }

    QueryBuilder generateJPQL(EntityManager em) {
        int propertyId = 0;
        QueryBuilder queryBuilder = new QueryBuilder();
        queryBuilder.addToSelectStatement("select dim from Dimension dim");
        queryBuilder.addToWhereClause(" where ");
        Iterator<MetadataItemQuery> it = this.metadataItemQueries.iterator();
        while (it.hasNext()) {
            MetadataItemQuery metadataItemQuery = it.next();
            String metadata_identifier = "meta" + propertyId;
            queryBuilder.addToSelectStatement(" join dim.metadataItems " + metadata_identifier);
            metadataItemQuery.generateJPQLWhereClause(queryBuilder, metadata_identifier);
            if (it.hasNext()) {
                queryBuilder.addToWhereClause(" and ");
            }
            ++propertyId;
        }
        return queryBuilder;
    }

    String generateJPQLWhereClause(String identifierVariable, EntityManager em) {
        return identifierVariable + ".id=" + this.getResults(em).get(0).getId() + "";
    }
}

