/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.query;

import com.ibm.cognos.internal.annotations.pojos.MetadataItem;
import com.ibm.cognos.internal.annotations.query.Query;
import com.ibm.cognos.internal.annotations.query.QueryBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;

public class MetadataItemQuery
implements Query {
    private List<MetadataItem> metadataItems = new ArrayList<MetadataItem>();
    private String propertyName;
    private List<String> values = new ArrayList<String>();

    public MetadataItemQuery(MetadataItem metadataItem, boolean forceFind) {
        if (!forceFind && metadataItem.getId() != 0L) {
            this.metadataItems.add(metadataItem);
        }
        this.propertyName = metadataItem.getName();
        this.values.add(metadataItem.getValue());
    }

    public MetadataItemQuery(MetadataItem metadataItem) {
        this(metadataItem, false);
    }

    public MetadataItemQuery(String name, String value) {
        this.propertyName = name;
        if (value != null) {
            this.values.add(value);
        }
    }

    public MetadataItemQuery(String name, List<String> values) {
        this.propertyName = name;
        this.values.addAll(values);
    }

    @Override
    public List<MetadataItem> getResults(EntityManager em) {
        if (this.metadataItems.isEmpty()) {
            javax.persistence.Query query = this.generateJPQL().buildQuery(em);
            List queryResults = query.getResultList();
            Iterator it = queryResults.iterator();
            while (it.hasNext()) {
                this.metadataItems.add((MetadataItem)it.next());
            }
        }
        return this.metadataItems;
    }

    @Override
    public void clear() {
        this.metadataItems.clear();
    }

    public static List<MetadataItemQuery> convert(List<MetadataItem> metadataItems) {
        ArrayList<MetadataItemQuery> queryList = new ArrayList<MetadataItemQuery>();
        for (MetadataItem metadataItem : metadataItems) {
            queryList.add(new MetadataItemQuery(metadataItem));
        }
        return queryList;
    }

    QueryBuilder generateJPQL() {
        QueryBuilder queryBuilder = new QueryBuilder();
        String identificationVariable = "m1";
        queryBuilder.addToSelectStatement("select ");
        queryBuilder.addToSelectStatement(identificationVariable);
        queryBuilder.addToSelectStatement(" from MetadataItem ");
        queryBuilder.addToSelectStatement(identificationVariable);
        queryBuilder.addToWhereClause(" where ");
        this.generateJPQLWhereClause(queryBuilder, identificationVariable);
        return queryBuilder;
    }

    void generateJPQLWhereClause(QueryBuilder queryBuilder, String idVar) {
        if (this.metadataItems.size() > 0) {
            if (this.metadataItems.size() == 1) {
                queryBuilder.addToWhereClause(idVar + ".id=:metadataItemId" + idVar);
                queryBuilder.setParameter("metadataItemId" + idVar, this.metadataItems.get(0).getId());
            } else {
                queryBuilder.addToWhereClause(idVar + ".id IN (:metadataItemTokens" + idVar + ")");
                Iterator<MetadataItem> it = this.metadataItems.iterator();
                ArrayList<Long> metadataItemTokenArray = new ArrayList<Long>();
                while (it.hasNext()) {
                    MetadataItem item = it.next();
                    metadataItemTokenArray.add(item.getId());
                }
                queryBuilder.setParameter("metadataItemTokens" + idVar, metadataItemTokenArray);
            }
        } else {
            if (this.propertyName != null) {
                queryBuilder.addToWhereClause(idVar + ".name=:propertyName" + idVar);
                queryBuilder.setParameter("propertyName" + idVar, this.propertyName);
                if (!this.values.isEmpty()) {
                    queryBuilder.addToWhereClause(" and ");
                }
            }
            if (this.values.size() == 1) {
                if (this.values.get(0).length() > 0) {
                    queryBuilder.addToWhereClause(idVar + ".value=:value" + idVar);
                    queryBuilder.setParameter("value" + idVar, this.values.get(0));
                } else {
                    queryBuilder.addToWhereClause(idVar + ".vE=:vEValue" + idVar);
                    queryBuilder.setParameter("vEValue" + idVar, MetadataItem.toShort(true));
                }
            } else if (this.values.size() != 0) {
                queryBuilder.addToWhereClause(idVar + ".value IN (:valueTokens" + idVar + ")");
                queryBuilder.setParameter("valueTokens" + idVar, this.values);
            }
        }
    }

    String getPropertyName() {
        return this.propertyName;
    }

    List<String> getValues() {
        return this.values;
    }
}

