/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.query;

import com.ibm.cognos.internal.annotations.pojos.Model;
import com.ibm.cognos.internal.annotations.query.DimensionQuery;
import com.ibm.cognos.internal.annotations.query.Query;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;

public class ModelQuery
implements Query {
    ArrayList<Model> models = new ArrayList();
    private List<DimensionQuery> dimensionQueries;

    public ModelQuery(Model model, boolean forceFind) {
        if (!forceFind && model.getId() != 0L) {
            this.models.add(model);
        }
        this.dimensionQueries = DimensionQuery.convert(model.getDimensions());
    }

    public ModelQuery(Model model) {
        this(model, false);
    }

    public ModelQuery(List<DimensionQuery> dimensionQueries) {
        this.dimensionQueries = dimensionQueries;
    }

    @Override
    public List<Model> getResults(EntityManager em) {
        javax.persistence.Query query;
        List queryResults;
        Iterator it;
        if (this.models.isEmpty() && (it = (queryResults = (query = em.createQuery(this.generateJPQL(em))).getResultList()).iterator()).hasNext()) {
            this.models.add((Model)it.next());
        }
        return this.models;
    }

    @Override
    public void clear() {
        this.models.clear();
        if (this.dimensionQueries != null) {
            for (DimensionQuery dimensionQuery : this.dimensionQueries) {
                dimensionQuery.clear();
            }
        }
    }

    String generateJPQL(EntityManager em) {
        int propertyId = 0;
        String selectClause = "select model from Model model";
        String whereClause = " where ";
        Iterator<DimensionQuery> it = this.dimensionQueries.iterator();
        while (it.hasNext()) {
            DimensionQuery dimensionQuery = it.next();
            String dimensionIdentifier = "dimension" + propertyId;
            selectClause = selectClause + " join model.dimensions " + dimensionIdentifier;
            whereClause = whereClause + dimensionQuery.generateJPQLWhereClause(dimensionIdentifier, em);
            if (it.hasNext()) {
                whereClause = whereClause + " and ";
            }
            ++propertyId;
        }
        return selectClause + whereClause;
    }

    String generateJPQLWhereClause(String identifierVariable, EntityManager em) {
        return identifierVariable + ".id=" + this.getResults(em).get(0).getId();
    }
}

