/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.query;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TemporalType;

public class QueryBuilder {
    private StringBuffer selectStatement = new StringBuffer("");
    private StringBuffer whereClause = new StringBuffer("");
    private HashMap<String, Object> parameters = new HashMap();
    private HashMap<String, TemporalType> temporalParameters = new HashMap();

    public void addToSelectStatement(String selectPart) {
        this.selectStatement.append(selectPart);
    }

    public void addToWhereClause(String wherePart) {
        this.whereClause.append(wherePart);
    }

    public void setParameter(String parameterName, Calendar parameterValue, TemporalType temporalDescription) {
        if (this.parameters.containsKey(parameterName)) {
            throw new IllegalStateException("parameterName " + parameterName + " already set");
        }
        this.parameters.put(parameterName, parameterValue);
        this.temporalParameters.put(parameterName, temporalDescription);
    }

    public void setParameter(String parameterName, Date parameterValue, TemporalType temporalDescription) {
        if (this.parameters.containsKey(parameterName)) {
            throw new IllegalStateException("parameterName " + parameterName + " already set");
        }
        this.parameters.put(parameterName, parameterValue);
        this.temporalParameters.put(parameterName, temporalDescription);
    }

    public void setParameter(String parameterName, Object parameterValue) {
        if (this.parameters.containsKey(parameterName)) {
            throw new IllegalStateException("parameterName " + parameterName + " already set");
        }
        this.parameters.put(parameterName, parameterValue);
    }

    public Query buildQuery(EntityManager em) {
        Query query = em.createQuery(this.selectStatement.append(this.whereClause).toString());
        for (String key : this.parameters.keySet()) {
            Object value = this.parameters.get(key);
            TemporalType temporalType = this.temporalParameters.get(key);
            if (temporalType != null) {
                if (value instanceof Calendar) {
                    query.setParameter(key, (Calendar)value, temporalType);
                }
                if (!(value instanceof Date)) continue;
                query.setParameter(key, (Date)value, temporalType);
                continue;
            }
            query.setParameter(key, value);
        }
        return query;
    }
}

