/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.query;

import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import com.ibm.cognos.internal.annotations.pojos.Context;
import com.ibm.cognos.internal.annotations.pojos.DataItem;
import com.ibm.cognos.internal.annotations.pojos.Dimension;
import com.ibm.cognos.internal.annotations.pojos.DimensionMember;
import com.ibm.cognos.internal.annotations.pojos.MetadataItem;
import com.ibm.cognos.internal.annotations.pojos.Model;
import com.ibm.cognos.internal.annotations.query.ContextQuery;
import com.ibm.cognos.internal.annotations.query.DataItemQuery;
import com.ibm.cognos.internal.annotations.query.DimensionMemberQuery;
import com.ibm.cognos.internal.annotations.query.DimensionQuery;
import com.ibm.cognos.internal.annotations.query.MetadataItemQuery;
import com.ibm.cognos.internal.annotations.query.ModelQuery;
import com.ibm.cognos.internal.annotations.query.Query;
import java.lang.reflect.Constructor;
import java.util.Hashtable;

public class QueryFactory {
    Hashtable<Class, Class<? extends Query>> queryMap = new Hashtable();
    Hashtable<Class, Query> queryMapOverrides = new Hashtable();

    public QueryFactory() {
        this.queryMap.put(Context.class, ContextQuery.class);
        this.queryMap.put(DataItem.class, DataItemQuery.class);
        this.queryMap.put(DimensionMember.class, DimensionMemberQuery.class);
        this.queryMap.put(MetadataItem.class, MetadataItemQuery.class);
        this.queryMap.put(Model.class, ModelQuery.class);
        this.queryMap.put(Dimension.class, DimensionQuery.class);
    }

    public Query getQuery(Object objConvert) throws AnnotationServiceException {
        Query query = null;
        Query override = this.queryMapOverrides.get(objConvert.getClass());
        if (override != null) {
            query = override;
        } else {
            Class<? extends Query> queryClass = this.queryMap.get(objConvert.getClass());
            if (queryClass != null) {
                try {
                    Constructor<? extends Query> constructor = queryClass.getConstructor(objConvert.getClass());
                    query = constructor.newInstance(objConvert);
                }
                catch (Exception e) {
                    throw new AnnotationServiceException(AnnotationI18NCode.QUERY_CONSTRUCTOR_ERROR, new Object[]{objConvert.getClass().getName()}, e);
                }
            } else {
                throw new AnnotationServiceException(AnnotationI18NCode.QUERY_NOT_FOUND, new Object[]{objConvert.getClass().getName()});
            }
        }
        return query;
    }

    void addQuery(Class classToQuery, Class<? extends Query> query) {
        this.queryMap.put(classToQuery, query);
    }

    void addQueryOverride(Class classToQuery, Query query) {
        this.queryMapOverrides.put(classToQuery, query);
    }
}

