/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.schema;

import com.ibm.cognos.internal.annotations.dao.VersionDAO;
import com.ibm.cognos.internal.annotations.dao.impl.DAOFactory;
import com.ibm.cognos.internal.annotations.pojos.Version;
import com.ibm.cognos.internal.hts.schema.IVersionUpdate;
import java.sql.Connection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAPersistence;

public class AnnotationVersion
implements IVersionUpdate {
    private EntityManagerFactory entityManagerFactory;
    private DAOFactory daofactory;

    public AnnotationVersion(EntityManagerFactory emfactory, DAOFactory daofactory) {
        this.entityManagerFactory = emfactory;
        this.daofactory = daofactory;
    }

    @Override
    public int getDBVersionViaJdbc() throws Exception {
        EntityManager em = this.entityManagerFactory.createEntityManager();
        OpenJPAEntityManager kem = OpenJPAPersistence.cast((EntityManager)em);
        Connection conn = (Connection)kem.getConnection();
        VersionDAO dao = this.daofactory.buildDAO(VersionDAO.class);
        return dao.getNativeVersion(conn);
    }

    @Override
    public int getDBVersion() throws Exception {
        EntityManager em = this.entityManagerFactory.createEntityManager();
        VersionDAO dao = this.daofactory.buildDAO(VersionDAO.class);
        return dao.getVersion(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateDBVersion(int newVersion) {
        boolean update = false;
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            Version version;
            Query query = entityManager.createQuery("select version from Version version order by version.version desc");
            query.setMaxResults(1);
            List list = query.getResultList();
            Version version2 = version = list.size() == 0 ? null : (Version)list.get(0);
            if (version == null || version.getVersion() < newVersion) {
                transaction.begin();
                Version nversion = new Version();
                nversion.setVersion(newVersion);
                entityManager.persist((Object)nversion);
                transaction.commit();
                update = true;
            }
        }
        catch (Throwable t) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
        }
        finally {
            if (entityManager != null) {
                entityManager.close();
            }
        }
        return update;
    }
}

