/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.service;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.serverinst.InstanceUtil;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.ibm.cognos.internal.annotations.dao.impl.DAOFactory;
import com.ibm.cognos.internal.annotations.schema.AnnotationVersion;
import com.ibm.cognos.internal.hts.apiHandlers.context.AbstractContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.ITransactionHandler;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.OpenJPAUtil;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.PersistenceUnit;
import com.ibm.cognos.internal.hts.properties.HTSServerProperties;
import com.ibm.cognos.internal.hts.schema.PluginPropertySchemaVersionUpdateFactory;
import com.ibm.cognos.internal.hts.schema.SchemaUtil;
import com.ibm.cognos.internal.hts.util.Utils;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;

public class ANSDbUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createOrUpgradeSchema() {
        JDBCConfigurationImpl conf = null;
        ITransactionHandler trx = null;
        try {
            OpenJPAUtil.initialise();
            String versionStr = HTSServerProperties.getInstance().getProperty("annotations.version");
            int version = 1;
            if (versionStr != null) {
                version = Integer.valueOf(versionStr);
            }
            AnnotationVersion versionUpdater = new AnnotationVersion(OpenJPAUtil.getNamedEntityManagerFactory(PersistenceUnit.ANNOTATIONS), new DAOFactory());
            conf = null;
            trx = new OpenJPAUtil(PersistenceUnit.ANNOTATIONS);
            trx.openSession();
            AbstractContext.setCurrentTransactionHandler(trx);
            conf = OpenJPAUtil.createConfig();
            PluginPropertySchemaVersionUpdateFactory updateFactory = new PluginPropertySchemaVersionUpdateFactory(OpenJPAUtil.getNamedEntityManagerFactory(PersistenceUnit.ANNOTATIONS), PersistenceUnit.ANNOTATIONS);
            SchemaUtil util = new SchemaUtil(versionUpdater, updateFactory, conf);
            util.update(version, PersistenceUnit.ANNOTATIONS);
        }
        catch (Exception ex) {
            Utils.logException(ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug("ANSDBUtils : There was a problem during ANS schema create / upgrade on dispatcher with id: " + InstanceUtil.getLocalDispatcherNodeIDGuid());
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, (I18NCode)UsI18NCode.MSG_US_SCHEMA_UPDATE_FAILED, new Object[]{ex.getMessage()});
        }
        finally {
            if (conf != null) {
                conf.close();
            }
            if (trx != null) {
                trx.closeSession();
            }
            AbstractContext.setCurrentTransactionHandler(null);
        }
    }
}

