/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.service;

import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.tasks.thread.CommonTimerTasks;
import com.cognos.jsmcommon.util.Controller;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.cognos.internal.annotations.dao.AnnotationDAO;
import com.ibm.cognos.internal.annotations.dao.ContextDAO;
import com.ibm.cognos.internal.annotations.dao.DataItemDAO;
import com.ibm.cognos.internal.annotations.dao.DimensionDAO;
import com.ibm.cognos.internal.annotations.dao.DimensionMemberDAO;
import com.ibm.cognos.internal.annotations.dao.MetadataItemDAO;
import com.ibm.cognos.internal.annotations.dao.ModelDAO;
import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import com.ibm.cognos.internal.annotations.i18n.MessageResourceProvider;
import com.ibm.cognos.internal.annotations.i18n.MessageResources;
import com.ibm.cognos.internal.annotations.pojos.Annotation;
import com.ibm.cognos.internal.annotations.service.AnnotationLogger;
import com.ibm.cognos.internal.annotations.service.AnnotationLoggerProvider;
import com.ibm.cognos.internal.annotations.service.AnnotationResources;
import com.ibm.cognos.internal.annotations.users.CMProperties;
import com.ibm.cognos.internal.annotations.users.CMPropertiesImpl;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.TimerTask;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.QueryResultCache;
import org.apache.openjpa.persistence.StoreCache;

public class AnnotationHouseKeeper
extends TimerTask
implements Controller {
    private static final long DEFAULT_INTERVAL = 12L;
    private static final boolean DEFAULT_RUN_STARTUP = false;
    private static final int DEFAULT_ANNOTATION_LIFETIME = 180;
    private static DatatypeFactory factory = null;
    AnnotationResources resources = null;

    public AnnotationHouseKeeper(AnnotationResources resources) {
        this.resources = resources;
    }

    public synchronized void start() {
        long interval = 12L;
        boolean atStartup = false;
        String sInt = this.getProperty("housekeeping.run.interval");
        String sStart = this.getProperty("housekeeping.run.startup");
        try {
            if (sInt != null) {
                interval = Integer.valueOf(sInt).intValue();
            }
        }
        catch (NumberFormatException e) {
            interval = 12L;
        }
        if (sStart != null) {
            atStartup = "TRUE".equalsIgnoreCase(sStart);
        }
        if (interval > 0L) {
            interval *= 3600000L;
        }
        this.schedule(interval, atStartup);
    }

    protected void schedule(long interval, boolean atStartup) {
        CommonTimerTasks.getInstance().schedule((TimerTask)this, atStartup ? 0L : interval, interval);
    }

    protected String getProperty(String key) {
        try {
            return this.resources.getConfiguration().getProperty(key);
        }
        catch (PropertiesException e) {
            return null;
        }
    }

    public synchronized void stop() {
        this.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -180);
        Date cutoffDate = cal.getTime();
        try {
            String sLifetime = this.getProperty("ansAnnotationLifetime");
            if (sLifetime != null) {
                if (factory == null) {
                    factory = DatatypeFactory.newInstance();
                }
                Duration duration = factory.newDuration(sLifetime);
                Calendar durationCal = Calendar.getInstance();
                duration.negate().addTo(durationCal);
                cutoffDate = durationCal.getTime();
            }
        }
        catch (DatatypeConfigurationException e) {
            AnnotationLogger.getInstance().logRuntimeDebug("Exception creation duration" + e.getMessage(), null, null);
        }
        catch (Exception e) {
            AnnotationServiceException ase = new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_GENERAL_ERROR, (Throwable)e);
            AnnotationLogger.getInstance().logRuntimeErrorMessage(ase.getServerLocaleMessage(), null, null, null, ase.getTrace());
        }
        AnnotationLoggerProvider logger = AnnotationLogger.getInstance();
        MessageResourceProvider mess = MessageResources.getInstance();
        int numAnnotationsDeleted = 0;
        int numTextDeleted = 0;
        int numContextDeleted = 0;
        int numDimensionMembersDeleted = 0;
        int numDataItemsDeleted = 0;
        int numModelsDeleted = 0;
        int numDimmensionsDeleted = 0;
        int metadataItemsDeleted = 0;
        EntityManager em = null;
        EntityTransaction transaction = null;
        try {
            EntityManagerFactory emf = this.resources.getEntityManagerFactory();
            em = emf.createEntityManager();
            transaction = em.getTransaction();
            this.clearJPACaches();
            AnnotationDAO annotationDAO = this.resources.getDAOFactory().buildDAO(AnnotationDAO.class);
            Query query = annotationDAO.findAnnotationsOlderThan(em, cutoffDate);
            Hashtable<String, CMProperties> foundParents = new Hashtable<String, CMProperties>();
            ArrayList<Long> annotationIds = new ArrayList<Long>();
            List annotations = query.getResultList();
            for (Annotation annotation : annotations) {
                String parentId = annotation.getParentId();
                CMProperties properties = (CMProperties)foundParents.get(parentId);
                if (properties == null) {
                    properties = this.getCMProperties(annotation);
                    foundParents.put(parentId, properties);
                }
                if (properties.exists()) continue;
                annotationIds.add(annotation.getId());
            }
            if (annotationIds.size() > 0) {
                transaction.begin();
                annotationDAO = this.resources.getDAOFactory().buildDAO(AnnotationDAO.class);
                query = annotationDAO.deleteAnnotationByIDList(em, annotationIds);
                numAnnotationsDeleted = query.executeUpdate();
                transaction.commit();
            }
            OpenJPAEntityManager kem = this.getOpenJPAEntityManager(em);
            Connection conn = (Connection)kem.getConnection();
            conn.setAutoCommit(false);
            numTextDeleted = annotationDAO.deleteUnusedText(conn);
            ContextDAO contextDAO = this.resources.getDAOFactory().buildDAO(ContextDAO.class);
            numContextDeleted = contextDAO.deleteUnusedContexts(conn);
            DimensionMemberDAO dimensionMemberDAO = this.resources.getDAOFactory().buildDAO(DimensionMemberDAO.class);
            numDimensionMembersDeleted = dimensionMemberDAO.deleteDimensionMembers(conn);
            DataItemDAO dataItemDAO = this.resources.getDAOFactory().buildDAO(DataItemDAO.class);
            numDataItemsDeleted = dataItemDAO.deleteUnusedDataItems(conn);
            ModelDAO modelDAO = this.resources.getDAOFactory().buildDAO(ModelDAO.class);
            numModelsDeleted = modelDAO.deleteUnusedModels(conn);
            DimensionDAO dimensionDAO = this.resources.getDAOFactory().buildDAO(DimensionDAO.class);
            numDimmensionsDeleted = dimensionDAO.deleteUnusedDimensions(conn);
            MetadataItemDAO metadataItemDOA = this.resources.getDAOFactory().buildDAO(MetadataItemDAO.class);
            metadataItemsDeleted = metadataItemDOA.deleteUnusedMetadataItems(conn);
            conn.commit();
        }
        catch (Throwable t) {
            if (null != transaction && transaction.isActive()) {
                transaction.rollback();
            }
            AnnotationServiceException annEx = null;
            annEx = t instanceof AnnotationServiceException ? (AnnotationServiceException)t : new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_GENERAL_ERROR, t);
            AnnotationLogger.getInstance().logRuntimeErrorMessage(annEx.getServerLocaleMessage(), null, null, null, annEx.getTrace());
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
        logger.logRuntimeDebug(mess.getServerLocaleResMessage(AnnotationI18NCode.CLEANING_DELETED_COUNT, new Object[]{AnnotationI18NCode.ANNOTATION_TYPE, "" + numAnnotationsDeleted}), null, null);
        logger.logRuntimeDebug(mess.getServerLocaleResMessage(AnnotationI18NCode.CLEANING_DELETED_COUNT, new Object[]{AnnotationI18NCode.TEXT_TYPE, "" + numTextDeleted}), null, null);
        logger.logRuntimeDebug(mess.getServerLocaleResMessage(AnnotationI18NCode.CLEANING_DELETED_COUNT, new Object[]{AnnotationI18NCode.CONTEXT_TYPE, "" + numContextDeleted}), null, null);
        logger.logRuntimeDebug(mess.getServerLocaleResMessage(AnnotationI18NCode.CLEANING_DELETED_COUNT, new Object[]{AnnotationI18NCode.DIMMEMBER_TYPE, "" + numDimensionMembersDeleted}), null, null);
        logger.logRuntimeDebug(mess.getServerLocaleResMessage(AnnotationI18NCode.CLEANING_DELETED_COUNT, new Object[]{AnnotationI18NCode.DATAITEM_TYPE, "" + numDataItemsDeleted}), null, null);
        logger.logRuntimeDebug(mess.getServerLocaleResMessage(AnnotationI18NCode.CLEANING_DELETED_COUNT, new Object[]{AnnotationI18NCode.MODEL_TYPE, "" + numModelsDeleted}), null, null);
        logger.logRuntimeDebug(mess.getServerLocaleResMessage(AnnotationI18NCode.CLEANING_DELETED_COUNT, new Object[]{AnnotationI18NCode.DIMENSION_TYPE, "" + numDimmensionsDeleted}), null, null);
        logger.logRuntimeDebug(mess.getServerLocaleResMessage(AnnotationI18NCode.CLEANING_DELETED_COUNT, new Object[]{AnnotationI18NCode.METADATAITEM_TYPE, "" + metadataItemsDeleted}), null, null);
    }

    private void clearJPACaches() {
        OpenJPAEntityManagerFactory oemf = this.getOpenJPAEntityManagerFactory(this.resources.getEntityManagerFactory());
        QueryResultCache qcache = oemf.getQueryResultCache();
        qcache.evictAll();
        StoreCache scache = oemf.getStoreCache();
        scache.evictAll();
    }

    protected OpenJPAEntityManager getOpenJPAEntityManager(EntityManager em) {
        OpenJPAEntityManager kem = OpenJPAPersistence.cast((EntityManager)em);
        return kem;
    }

    protected OpenJPAEntityManagerFactory getOpenJPAEntityManagerFactory(EntityManagerFactory emf) {
        OpenJPAEntityManagerFactory kemf = OpenJPAPersistence.cast((EntityManagerFactory)emf);
        return kemf;
    }

    CMProperties getCMProperties(Annotation annotation) {
        BIBusEnvelope envelope = new BIBusEnvelope();
        CMPropertiesImpl cmProperties = new CMPropertiesImpl(annotation.getParentId(), this.resources.getClientFactory(), envelope, true);
        cmProperties.setRequestorOperation("HouseKeepingThread");
        return cmProperties;
    }
}

