/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.service;

import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogIndication;
import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import com.cognos.jsmcommon.version.BuildComposite;
import com.cognos.jsmcommon.version.IVersionInfo;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.cognos.internal.annotations.pojos.Annotation;
import com.ibm.cognos.internal.annotations.service.ANSVersionInfo;
import com.ibm.cognos.internal.annotations.service.AnnotationLoggerProvider;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class AnnotationIPFLogger
implements AnnotationLoggerProvider {
    protected LogTypedLogger annAuditLog = LogTypedLogger.getInstanceBe((String)"Audit.ANS", LogAuditIndication.class);
    protected LogTypedLogger annAuditRequestLog = LogTypedLogger.getInstanceBe((String)"Audit.ANS.Request", LogAuditIndication.class);
    protected LogTypedLogger annTraceLog = LogTypedLogger.getInstanceBe((String)"Trace.ANS", LogTraceIndication.class);
    private int m_iMajorVersion = this.getVersion();

    @Override
    public void logRuntimeErrorMessage(String message, String sOperation, String sessionID, String requestID, String stackTrace) {
        LogAuditAccessIndication indication = new LogAuditAccessIndication("ANS", this.m_iMajorVersion);
        if (this.annAuditLog != null && this.annAuditLog.isEnabled(50000)) {
            indication.setLevel(50000);
            indication.setStatus("Failure");
            indication.setObjectType("Annotation");
            if (sessionID != null) {
                indication.setSessionID(sessionID);
            }
            if (requestID != null) {
                indication.setRequestID(requestID);
            }
            indication.setOperation(sOperation);
            indication.setErrorMessage(this.formatErrorMessage(message));
            indication.setLogData(this.formatStackTrace(stackTrace));
            this.addToLog(this.annAuditLog, (LogIndication)indication);
        }
    }

    @Override
    public void logRuntimeWarning(String message, String sOperation, String sessionID, String requestID, String sTrace) {
        LogAuditAccessIndication indication = new LogAuditAccessIndication("ANS", this.m_iMajorVersion);
        if (this.annAuditLog != null && this.annAuditLog.isEnabled(40000)) {
            indication.setLevel(40000);
            indication.setStatus("Failure");
            indication.setObjectType("Annotation");
            if (sessionID != null) {
                indication.setSessionID(sessionID);
            }
            if (requestID != null) {
                indication.setRequestID(requestID);
            }
            indication.setOperation(sOperation);
            indication.setErrorMessage(this.formatErrorMessage(message));
            indication.setLogData(this.formatStackTrace(sTrace));
            this.addToLog(this.annAuditLog, (LogIndication)indication);
        }
    }

    @Override
    public void logRuntimeDebug(String message, String sessionID, String requestID) {
        LogTraceIndication indication = new LogTraceIndication("ANS", this.m_iMajorVersion);
        if (this.annTraceLog != null && this.annTraceLog.isEnabled(10000)) {
            indication.setLevel(10000);
            if (sessionID != null) {
                indication.setSessionID(sessionID);
            }
            if (requestID != null) {
                indication.setRequestID(requestID);
            }
            indication.setMessage("<trace><![CDATA[ " + message + " ]]></trace>");
            this.addToLog(this.annTraceLog, (LogIndication)indication);
        }
    }

    public boolean isUserRequestLogging() {
        return this.annAuditLog != null && this.annAuditLog.isEnabled(30000);
    }

    @Override
    public void logUserRequest(String sOperation, BIBusEnvelope request, Annotation annotation) {
        String sessionID = request.getPassportID();
        String requestID = request.getTrackingRequestContext();
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (annotation.getId() != 0L) {
            parameters.put("annotation_id", "" + annotation.getId());
        }
        if (annotation.getOwner() != null) {
            parameters.put("user", annotation.getOwner());
        }
        if (annotation.getParentId() != null) {
            parameters.put("parent_id", annotation.getParentId());
        }
        if (annotation.getCreationTime() != null) {
            parameters.put("creation_time", "" + annotation.getCreationTime().getTime());
        }
        if (annotation.getLastModificationTime() != null) {
            parameters.put("update_time", "" + annotation.getLastModificationTime().getTime());
        }
        this.logUserRequest(sOperation, parameters, sessionID, requestID);
    }

    @Override
    public void logUserRequest(String sOperation, Map mParameters, String sessionID, String requestID) {
        LogAuditAccessIndication indication = new LogAuditAccessIndication("ANS", this.m_iMajorVersion);
        if (this.isUserRequestLogging()) {
            indication.setLevel(30000);
            indication.setStatus("Success");
            indication.setObjectType("Annotation");
            if (sessionID != null) {
                indication.setSessionID(sessionID);
            }
            if (requestID != null) {
                indication.setRequestID(requestID);
            }
            indication.setOperation(sOperation);
            if (mParameters != null) {
                indication.setLogData(this.formatParameters(mParameters));
            }
            this.addToLog(this.annAuditLog, (LogIndication)indication);
        }
    }

    @Override
    public void logUserResponse(String sOperation, String sResponse, String sessionID, String requestID) {
        LogAuditAccessIndication indication = new LogAuditAccessIndication("ANS", this.m_iMajorVersion);
        if (this.isUserRequestLogging()) {
            indication.setLevel(30000);
            indication.setStatus("Success");
            indication.setObjectType("Annotation");
            if (sessionID != null) {
                indication.setSessionID(sessionID);
            }
            if (requestID != null) {
                indication.setRequestID(requestID);
            }
            indication.setOperation(sOperation);
            if (sResponse != null) {
                indication.setLogData(this.formatParameters(null));
            }
            this.addToLog(this.annAuditLog, (LogIndication)indication);
        }
    }

    public boolean isSystemRequestLogging() {
        return this.annAuditRequestLog != null && this.annAuditRequestLog.isEnabled(20000);
    }

    @Override
    public void logBiBusRequest(BIBusEnvelope request) {
        String sessionID = request.getPassportID();
        String requestID = request.getTrackingRequestContext();
        try {
            this.logSystemRequest(request.getAsString(), sessionID, requestID);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void logSystemRequest(String sRequestXML, String sessionId, String requestId) {
        if (this.isSystemRequestLogging()) {
            LogAuditIndication indication = new LogAuditIndication("ANS", this.m_iMajorVersion);
            indication.setLevel(20000);
            indication.setOperation("Request");
            indication.setSessionID(sessionId);
            indication.setRequestID(requestId);
            StringBuffer sBuffer = new StringBuffer(sRequestXML);
            sBuffer.insert(0, "<request>");
            sBuffer.append("</request>");
            int iStart = sBuffer.toString().indexOf("<?");
            int iEnd = sBuffer.toString().indexOf("?>");
            if (iStart > -1 && iEnd > -1) {
                sBuffer.delete(iStart, iEnd + 2);
            }
            indication.setLogData(sBuffer.toString());
            this.addToLog(this.annAuditRequestLog, (LogIndication)indication);
        }
    }

    @Override
    public void logBIBusResponse(BIBusEnvelope response) {
        try {
            String sessionID = response.getPassportID();
            String requestID = response.getTrackingRequestContext();
            this.logSystemResponse(response.getAsString(), sessionID, requestID);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void logSystemResponse(String sResponseXML, String sessionId, String requestId) {
        if (this.isSystemRequestLogging()) {
            LogAuditIndication indication = new LogAuditIndication("ANS", this.m_iMajorVersion);
            indication.setLevel(20000);
            indication.setOperation("Response");
            indication.setSessionID(sessionId);
            indication.setRequestID(requestId);
            indication.setLogData(sResponseXML);
            StringBuffer sBuffer = new StringBuffer(sResponseXML);
            sBuffer.insert(0, "<response>");
            sBuffer.append("</response>");
            int iStart = sBuffer.toString().indexOf("<?");
            int iEnd = sBuffer.toString().indexOf("?>");
            sBuffer.delete(iStart, iEnd + 2);
            indication.setLogData(sBuffer.toString());
            this.addToLog(this.annAuditRequestLog, (LogIndication)indication);
        }
    }

    private String formatParameters(Map mParameters) {
        StringBuffer buff = new StringBuffer();
        buff.append("<parameters>");
        for (String sParamName : mParameters.keySet()) {
            String sParamValue = (String)mParameters.get(sParamName);
            if (sParamName == null || sParamValue == null) continue;
            buff.append("<item name=\"");
            buff.append(sParamName);
            buff.append("\">");
            buff.append("<![CDATA[");
            buff.append(sParamValue);
            buff.append("]]></item>");
        }
        buff.append("</parameters>");
        return buff.toString();
    }

    private String formatErrorMessage(String message) {
        if (message == null) {
            return "";
        }
        String sFmtMessage = "<messages><message><messageString>" + message + "</messageString></message>";
        return sFmtMessage;
    }

    private String formatStackTrace(String trace) {
        String sFmtMessage = "<trace>" + trace + "</trace>";
        sFmtMessage = sFmtMessage.replace('\n', ' ');
        return sFmtMessage;
    }

    void addToLog(LogTypedLogger logger, LogIndication indication) {
        logger.log((Object)indication);
    }

    int getVersion() {
        return this.getANSVersionInformation().getBuildComposite(BuildComposite.MAJOR_VERSION);
    }

    IVersionInfo getANSVersionInformation() {
        return ANSVersionInfo.instance();
    }
}

