/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.service;

import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.UserSessionIDSession;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.metrics.MetricsManager;
import com.cognos.jsmcommon.property.CMProperties;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.util.Controller;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.StringUtils;
import com.ibm.cognos.internal.annotations.caf.AnnotationCafValidator;
import com.ibm.cognos.internal.annotations.commands.AnnotationCommand;
import com.ibm.cognos.internal.annotations.convert.deserialize.DeserializerFactory;
import com.ibm.cognos.internal.annotations.convert.serialize.SerializerFactory;
import com.ibm.cognos.internal.annotations.dao.impl.DAOFactory;
import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import com.ibm.cognos.internal.annotations.i18n.BundledMessageResources;
import com.ibm.cognos.internal.annotations.i18n.MessageResources;
import com.ibm.cognos.internal.annotations.metrics.AnnotationPerf;
import com.ibm.cognos.internal.annotations.metrics.AnnotationPerfMBeanImpl;
import com.ibm.cognos.internal.annotations.persist.PersistorFactory;
import com.ibm.cognos.internal.annotations.query.QueryFactory;
import com.ibm.cognos.internal.annotations.service.AnnotationHouseKeeper;
import com.ibm.cognos.internal.annotations.service.AnnotationIPFLogger;
import com.ibm.cognos.internal.annotations.service.AnnotationLogger;
import com.ibm.cognos.internal.annotations.service.AnnotationResources;
import com.ibm.cognos.internal.annotations.service.CommandFactory;
import com.ibm.cognos.internal.annotations.service.RestOP;
import com.ibm.cognos.internal.annotations.service.RestResponse;
import com.ibm.cognos.internal.annotations.users.Authenticator;
import com.ibm.cognos.internal.annotations.users.AuthenticatorImpl;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.OpenJPAUtil;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.PersistenceUnit;
import com.ibm.cognos.jsmcommon.dbschemavalidator.DBSchemaValidator;
import com.ibm.cognos.jsmcommon.dbschemavalidator.DBSchemaValidatorAtIntervals;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import javax.mail.internet.InternetHeaders;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class AnnotationServiceHandler
extends BasicHandler {
    protected static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(AnnotationServiceHandler.class.getName());
    protected boolean m_suspended = false;
    protected static final String RESPONSE_NAME = "response";
    public static final String SOAP_ENVELOPE = "request.envelope";
    private AnnotationResources resources = new AnnotationResources();
    private Controller m_housekeeper = null;
    private boolean m_serviceFailedToInit = false;
    private CAMFactory m_camFactory = null;
    private AnnotationCafValidator m_cafValidator = null;

    public AnnotationServiceHandler() {
        super(null);
    }

    public void start() {
        if (this.m_serviceFailedToInit) {
            this.flagNotStartable();
            throw new RuntimeException("Annotation Service Failed to start");
        }
        this.resumeNow();
        DBSchemaValidatorAtIntervals.getInstance().startDBSchemaValidationAtIntervals(DBSchemaValidator.ComponentName.ANN);
    }

    public void stop() {
        this.suspendNow();
    }

    public void resume() {
        if (this.m_serviceFailedToInit) {
            throw new RuntimeException("Annotation Service could not be resumed");
        }
        this.resumeNow();
    }

    public void suspend() {
        this.suspendNow();
    }

    public void suspend(boolean immediately) {
        if (this.m_serviceFailedToInit) {
            throw new RuntimeException("Annotation Service could not be suspended");
        }
        this.suspendNow();
    }

    private synchronized void resumeNow() {
        try {
            this.setSuspended(false);
            if (this.m_housekeeper == null) {
                this.m_housekeeper = this.getHouseKeeper();
                this.m_housekeeper.start();
            }
        }
        catch (Throwable t) {
            this.m_serviceFailedToInit = true;
            this.flagNotStartable();
            AnnotationServiceException annEx = new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_GENERAL_ERROR, t);
            AnnotationLogger.getInstance().logRuntimeErrorMessage(annEx.getServerLocaleMessage(), null, null, null, annEx.getTrace());
        }
    }

    private synchronized void suspendNow() {
        this.setSuspended(true);
        if (this.m_housekeeper != null) {
            this.m_housekeeper.stop();
            this.m_housekeeper = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeImpl(MessageContext mc) throws PogoException {
        Date perf_start = new Date();
        AnnotationPerfMBeanImpl.getInstance().incrementAnnotationServiceRequestCount();
        if (this.isSuspended()) {
            mc.setFault(new Fault("AbortIfSuspendedHandler.serviceStopped"));
            AnnotationPerfMBeanImpl.getInstance().updateTimeInAnnotationService(perf_start, new Date());
            return;
        }
        BIBusEnvelope requestEnv = (BIBusEnvelope)mc.getProperty(SOAP_ENVELOPE);
        Authenticator authenticator = this.getAuthenticator();
        InternetHeaders hdrs = (InternetHeaders)mc.getProperty("request.headers");
        String[] sAction = hdrs.getHeader("soapAction");
        boolean bRestReq = sAction == null;
        String pathInfo = (String)mc.getProperty("path_info");
        boolean bAnnEndPoint = pathInfo != null && pathInfo.startsWith("/annotationService/");
        try {
            if (bRestReq || bAnnEndPoint) {
                try {
                    authenticator.authenticate(mc);
                    this.processFormMessage(mc);
                }
                catch (AnnotationServiceException annEx) {
                    this.fillMCRestFault(mc, annEx);
                }
            } else {
                try {
                    authenticator.authenticate(mc);
                    this.processSoapCommand(mc, requestEnv);
                }
                catch (AnnotationServiceException annEx) {
                    this.generateFaultResponse(mc, annEx);
                }
            }
        }
        finally {
            AnnotationPerfMBeanImpl.getInstance().updateTimeInAnnotationService(perf_start, new Date());
        }
    }

    protected BIBusEnvelope buildBiBusResponse(BIBusEnvelope requestEnvelope, Element responseElement) {
        Element ffVars;
        Element responseHeader = requestEnvelope.getHeader().createCopy();
        Element envVars = responseHeader.element(BIBusEnvelope.BUS_ENVIRONMENT_VARS);
        if (envVars != null) {
            envVars.detach();
        }
        if ((ffVars = responseHeader.element(BIBusEnvelope.BUS_FORM_FIELD_VARS)) != null) {
            ffVars.detach();
        }
        BIBusEnvelope responseEnvelope = new BIBusEnvelope(responseHeader);
        responseEnvelope.getBody().add(responseElement);
        return responseEnvelope;
    }

    private void processSoapCommand(MessageContext mc, BIBusEnvelope requestEnv) throws AnnotationServiceException {
        Element operationElement;
        BIBusEnvelope response = null;
        AnnotationLogger.getInstance().logBiBusRequest(requestEnv);
        Element body = requestEnv.getBody();
        if (body != null && (operationElement = (Element)body.selectSingleNode("./*")) != null) {
            try {
                CommandFactory commandFactory = this.resources.getCommandFactory();
                AnnotationCommand annotationCommand = commandFactory.getSoapCommand(operationElement.getQName(), mc, this.resources);
                Element responseElement = annotationCommand.performSoapAction();
                response = this.buildBiBusResponse(requestEnv, responseElement);
                AnnotationLogger.getInstance().logBIBusResponse(response);
                this.buildResponse(mc, response);
            }
            catch (Throwable t) {
                AnnotationServiceException annEx = null;
                annEx = t instanceof AnnotationServiceException ? (AnnotationServiceException)t : new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_GENERAL_ERROR, t);
                throw annEx;
            }
        }
    }

    private void processFormMessage(MessageContext mc) throws AnnotationServiceException {
        String pathInfo = (String)mc.getProperty("path_info");
        String[] parts = pathInfo.split("/");
        String httpMethod = (String)mc.getProperty("request.method");
        if (httpMethod == null) {
            BIBusEnvelope request_env = (BIBusEnvelope)mc.getProperty(SOAP_ENVELOPE);
            httpMethod = request_env.getEnvironmentValue("REQUEST_METHOD");
        }
        if (parts.length < 3) {
            AnnotationServiceException annEx = new AnnotationServiceException(AnnotationI18NCode.INVALID_REST_PATH, new Object[]{pathInfo}, AnnotationServiceException.FaultType.REQUEST_ERROR);
            BIBusEnvelope request = (BIBusEnvelope)mc.getProperty(SOAP_ENVELOPE);
            String sessionID = request != null ? request.getPassportID() : null;
            String requestID = request != null ? request.getTrackingRequestContext() : null;
            AnnotationLogger.getInstance().logRuntimeErrorMessage(annEx.getServerLocaleMessage(), null, sessionID, requestID, annEx.getTrace());
            throw annEx;
        }
        String resource_type = parts[2];
        String resource_type_id = parts.length > 3 ? parts[3] : null;
        RestOP restOperation = new RestOP(httpMethod, resource_type);
        try {
            AnnotationLogger.getInstance().logBiBusRequest((BIBusEnvelope)mc.getProperty(SOAP_ENVELOPE));
            this.checkAuthenticityToken(httpMethod, (BIBusEnvelope)mc.getProperty(SOAP_ENVELOPE));
            this.validateParameters((BIBusEnvelope)mc.getProperty(SOAP_ENVELOPE));
            CommandFactory commandFactory = this.resources.getCommandFactory();
            AnnotationCommand annotationCommand = commandFactory.getRestCommand(restOperation, mc, this.resources);
            RestResponse response = annotationCommand.performRestAction(resource_type_id);
            this.fillMCRestResponse(mc, response);
        }
        catch (Throwable t) {
            AnnotationServiceException annEx = null;
            annEx = t instanceof AnnotationServiceException ? (AnnotationServiceException)t : new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_GENERAL_ERROR, t);
            throw annEx;
        }
    }

    public void configure(Configuration configuration) {
        CRNProperties config = CRNProperties.getInstance();
        config.init(configuration.getICCLConfiguration(), this.getName());
        this.resources.setConfiguration(config);
        CMProperties cmConfig = CMProperties.getInstance();
        cmConfig.init(configuration.getICCLConfiguration());
    }

    public void reconfigure(Configuration configuration) {
        this.configure(configuration);
    }

    private void buildResponse(MessageContext mc, BIBusEnvelope response) throws Exception {
        if (response == null) {
            throw new AnnotationServiceException(AnnotationI18NCode.NULL_SERVICE_RESPONSE);
        }
        this.fillMCSoapResponse(mc, response);
    }

    private void setSuspended(boolean suspended) {
        this.m_suspended = suspended;
    }

    private boolean isSuspended() {
        return this.m_suspended;
    }

    private void generateFaultResponse(MessageContext mc, AnnotationServiceException annEx) {
        BIBusEnvelope request = (BIBusEnvelope)mc.getProperty(SOAP_ENVELOPE);
        String sessionID = request != null ? request.getPassportID() : null;
        String requestID = request != null ? request.getTrackingRequestContext() : null;
        AnnotationLogger.getInstance().logRuntimeErrorMessage(annEx.getServerLocaleMessage(), null, sessionID, requestID, annEx.getTrace());
        BIBusEnvelope faultResponse = annEx.generateFault(mc);
        AnnotationLogger.getInstance().logBIBusResponse(faultResponse);
        this.fillMCSoapResponse(mc, faultResponse);
    }

    private void fillMCSoapResponse(MessageContext mc, BIBusEnvelope responseEnvelope) {
        Element bigFault = responseEnvelope.getBody().element("Fault");
        Element littleFault = responseEnvelope.getBody().element("fault");
        mc.setResponseName(RESPONSE_NAME);
        mc.setProperty("response.envelope", (Object)responseEnvelope);
        if (bigFault != null || littleFault != null) {
            mc.setProperty("response.status_code", (Object)"500");
            mc.setProperty("response.status_msg", (Object)"Internal Server error");
        } else {
            mc.setProperty("response.status_code", (Object)"200");
            mc.setProperty("response.status_msg", (Object)"OK");
        }
        InternetHeaders headers = new InternetHeaders();
        headers.setHeader("Content-Type", "text/xml");
        mc.setProperty("response.headers", (Object)headers);
        mc.setProperty("response.boundary", null);
        mc.setProperty("response.attachments", null);
    }

    private void fillMCRestFault(MessageContext mc, AnnotationServiceException annEx) {
        BIBusEnvelope request = (BIBusEnvelope)mc.getProperty(SOAP_ENVELOPE);
        String sessionID = request != null ? request.getPassportID() : null;
        String requestID = request != null ? request.getTrackingRequestContext() : null;
        AnnotationLogger.getInstance().logRuntimeErrorMessage(annEx.getServerLocaleMessage(), null, sessionID, requestID, annEx.getTrace());
        Locale locale = (Locale)mc.getProperty("locale");
        if (locale == null) {
            locale = new Locale("en");
        }
        InternetHeaders responseHeaders = new InternetHeaders();
        BIBusEnvelope dummyEnvelope = new BIBusEnvelope();
        String contentTypeHeader = "Content-Type: text/xml; charset=utf-8\r\n\r\n";
        byte[] contentTypeHeaderBytes = null;
        try {
            contentTypeHeaderBytes = contentTypeHeader.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        Element error = DocumentHelper.createElement((String)"error");
        annEx.generateRESTDetails(error, locale);
        ByteArrayInputStream responseStream = new ByteArrayInputStream(error.asXML().getBytes());
        SequenceInputStream compositeStream = new SequenceInputStream(new ByteArrayInputStream(contentTypeHeaderBytes), responseStream);
        ArrayList<SequenceInputStream> attachmentList = new ArrayList<SequenceInputStream>(1);
        attachmentList.add(compositeStream);
        mc.setResponseName(RESPONSE_NAME);
        mc.setProperty("response.status_code", (Object)annEx.getFault().errorCode());
        mc.setProperty("response.headers", (Object)responseHeaders);
        mc.setProperty("response.envelope", (Object)dummyEnvelope);
        mc.setProperty("response.attachments", attachmentList.iterator());
        mc.setProperty("response.boundary", (Object)StringUtils.getUniqueValue());
    }

    private void fillMCRestResponse(MessageContext mc, RestResponse response) {
        InternetHeaders responseHeaders = new InternetHeaders();
        BIBusEnvelope dummyEnvelope = new BIBusEnvelope();
        String contentTypeHeader = "Content-Type: " + response.getContentType() + "; charset=utf-8\r\n\r\n";
        byte[] contentTypeHeaderBytes = null;
        try {
            contentTypeHeaderBytes = contentTypeHeader.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        SequenceInputStream compositeStream = new SequenceInputStream(new ByteArrayInputStream(contentTypeHeaderBytes), response.getStream());
        ArrayList<SequenceInputStream> attachmentList = new ArrayList<SequenceInputStream>(1);
        attachmentList.add(compositeStream);
        mc.setResponseName(RESPONSE_NAME);
        mc.setProperty("response.status_code", (Object)"200");
        mc.setProperty("response.status_msg", (Object)"OK");
        mc.setProperty("response.headers", (Object)responseHeaders);
        mc.setProperty("response.envelope", (Object)dummyEnvelope);
        mc.setProperty("response.attachments", attachmentList.iterator());
        mc.setProperty("response.boundary", (Object)StringUtils.getUniqueValue());
    }

    private void outputBIBusEnvelope(BIBusEnvelope envelope, I18NCode code) {
        if (SDSLogger.getLogger((SDSCategory)JSMCommonCategory.AUDIT_REQUEST).isLoggingAt(SDSLevel.INFO)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                envelope.writeAsXML((OutputStream)baos);
                String requestString = baos.toString("UTF-8");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.AUDIT_REQUEST).log(SDSLevel.INFO, code, (Object[])new String[]{requestString});
            }
            catch (IOException ex) {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug("Exception logging debug " + ex.getMessage());
            }
        }
    }

    public void compose_impl(PogoEngine engine) throws PogoException {
    }

    public void initialize() {
        this.resources.setCommandFactory(new CommandFactory());
        this.resources.setDeserializerFactory(new DeserializerFactory());
        this.resources.setSerializerFactory(new SerializerFactory());
        this.resources.setQueryFactory(new QueryFactory());
        this.resources.setClientFactory(Client.instance());
        this.resources.setPersistorFactory(new PersistorFactory());
        this.resources.setDAOFactory(new DAOFactory());
        this.resources.setEntityManagerFactory(OpenJPAUtil.getNamedEntityManagerFactory(PersistenceUnit.ANNOTATIONS));
        MessageResources.setInstance(new BundledMessageResources());
        AnnotationLogger.setInstance(new AnnotationIPFLogger());
        AnnotationPerf annotationPerf = new AnnotationPerf();
        MetricsManager metricsManager = MetricsManager.getInstance();
        metricsManager.registerMBean((Object)annotationPerf, "AnnotationServicePerf", "perf");
    }

    public AnnotationResources getResources() {
        return this.resources;
    }

    void setResources(AnnotationResources resources) {
        this.resources = resources;
    }

    Controller getHouseKeeper() {
        return new AnnotationHouseKeeper(this.resources);
    }

    Authenticator getAuthenticator() {
        return new AuthenticatorImpl();
    }

    void validateParameters(BIBusEnvelope requestEnvelope) throws AnnotationServiceException {
        this.getCAFValidator().validate(requestEnvelope);
    }

    void checkAuthenticityToken(String httpMethod, BIBusEnvelope requestEnvelope) throws AnnotationServiceException {
        int verifyTokenResult;
        UserSessionIDSession usIDSession;
        Node userSessionIDNode;
        Element camElement;
        if (httpMethod.equalsIgnoreCase("GET")) {
            return;
        }
        String authToken = requestEnvelope.getFormValue("COM-IBM-COGNOS-AUTHENTICITYTOKEN");
        if (authToken == null || authToken.length() == 0) {
            authToken = requestEnvelope.getEnvironmentValue("COM-IBM-COGNOS-AUTHENTICITYTOKEN");
        }
        String userSessionID = null;
        if (requestEnvelope.getCAM() != null && (camElement = requestEnvelope.getCAM()) != null && (userSessionIDNode = camElement.selectSingleNode("./*[local-name()='userSessionID']")) != null) {
            userSessionID = userSessionIDNode.getText();
        }
        if (authToken == null || userSessionID == null) {
            throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_GENERAL_ERROR, AnnotationServiceException.FaultType.FORBIDDEN);
        }
        byte[] authTokenBytes = authToken.getBytes();
        byte[] userSessionIDBytes = userSessionID.getBytes();
        try {
            usIDSession = this.getCAMFactory().createUserSessionIDSession();
        }
        catch (Exception e) {
            throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_GENERAL_ERROR, AnnotationServiceException.FaultType.FORBIDDEN);
        }
        try {
            verifyTokenResult = usIDSession.verifyAuthenticityToken(authTokenBytes, userSessionIDBytes);
        }
        catch (Exception e) {
            throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_GENERAL_ERROR, AnnotationServiceException.FaultType.FORBIDDEN);
        }
        if (verifyTokenResult < 0) {
            throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_GENERAL_ERROR, AnnotationServiceException.FaultType.FORBIDDEN);
        }
    }

    private synchronized CAMFactory getCAMFactory() throws AnnotationServiceException {
        if (this.m_camFactory == null) {
            try {
                this.m_camFactory = new CAMFactory();
                this.m_camFactory.initialize("<initializeDocument><serviceID>ANS</serviceID></initializeDocument>".getBytes());
            }
            catch (Exception e) {
                throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_GENERAL_ERROR);
            }
        }
        return this.m_camFactory;
    }

    private synchronized AnnotationCafValidator getCAFValidator() throws AnnotationServiceException {
        if (this.m_cafValidator == null) {
            try {
                this.m_cafValidator = new AnnotationCafValidator();
            }
            catch (Exception e) {
                throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_GENERAL_ERROR);
            }
        }
        return this.m_cafValidator;
    }
}

