/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.service;

import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.internal.annotations.commands.AnnotationCommand;
import com.ibm.cognos.internal.annotations.commands.AtomFeedCommand;
import com.ibm.cognos.internal.annotations.commands.CheckAnnotationCommand;
import com.ibm.cognos.internal.annotations.commands.CloneAnnotationCommand;
import com.ibm.cognos.internal.annotations.commands.CreateAnnotationCommand;
import com.ibm.cognos.internal.annotations.commands.DeleteAnnotationCommand;
import com.ibm.cognos.internal.annotations.commands.ReadAnnotationCommand;
import com.ibm.cognos.internal.annotations.commands.UpdateAnnotationCommand;
import com.ibm.cognos.internal.annotations.commands.WSDLCommand;
import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import com.ibm.cognos.internal.annotations.service.AnnotationResources;
import com.ibm.cognos.internal.annotations.service.RestOP;
import com.ibm.cognos.internal.annotations.service.XMLSOAPHelper;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import org.dom4j.QName;

public class CommandFactory {
    private Hashtable<QName, Class<? extends AnnotationCommand>> soapCommands = new Hashtable();
    private Hashtable<QName, AnnotationCommand> soapCommandOverrides = new Hashtable();
    private Hashtable<RestOP, Class<? extends AnnotationCommand>> restCommands = new Hashtable();
    private Hashtable<RestOP, AnnotationCommand> restCommandOverrides = new Hashtable();

    public CommandFactory() {
        this.initSoapMap();
        this.initRestMap();
    }

    private void initSoapMap() {
        this.soapCommands.put(XMLSOAPHelper.ANN_CREATE_REQUEST, CreateAnnotationCommand.class);
        this.soapCommands.put(XMLSOAPHelper.ANN_READ_BY_ID_REQUEST, ReadAnnotationCommand.class);
        this.soapCommands.put(XMLSOAPHelper.ANN_READ_BY_PARENT_ID_REQUEST, ReadAnnotationCommand.class);
        this.soapCommands.put(XMLSOAPHelper.ANN_DELETE_BY_ID_REQUEST, DeleteAnnotationCommand.class);
        this.soapCommands.put(XMLSOAPHelper.ANN_DELETE_BY_PARENT_ID_REQUEST, DeleteAnnotationCommand.class);
        this.soapCommands.put(XMLSOAPHelper.ANN_UPDATE_REQUEST, UpdateAnnotationCommand.class);
        this.soapCommands.put(XMLSOAPHelper.ANN_CHECK_REQUEST, CheckAnnotationCommand.class);
        this.soapCommands.put(XMLSOAPHelper.ANN_CLONE_REQUEST, CloneAnnotationCommand.class);
        this.soapCommands.put(XMLSOAPHelper.ANN_CLONE_BY_PARENT_ID_REQUEST, CloneAnnotationCommand.class);
    }

    private void initRestMap() {
        this.restCommands.put(new RestOP("GET", "annotation"), ReadAnnotationCommand.class);
        this.restCommands.put(new RestOP("GET", "annotationList"), ReadAnnotationCommand.class);
        this.restCommands.put(new RestOP("GET", "atom"), AtomFeedCommand.class);
        this.restCommands.put(new RestOP("GET", "wsdl"), WSDLCommand.class);
        this.restCommands.put(new RestOP("POST", "deletionList"), DeleteAnnotationCommand.class);
        this.restCommands.put(new RestOP("POST", "annotation"), UpdateAnnotationCommand.class);
        this.restCommands.put(new RestOP("POST", "creation"), CreateAnnotationCommand.class);
    }

    public AnnotationCommand getSoapCommand(QName operationName, MessageContext mc, AnnotationResources resources) throws AnnotationServiceException {
        AnnotationCommand annotationCommand = null;
        AnnotationCommand annotationCommandOverride = this.soapCommandOverrides.get(operationName);
        if (annotationCommandOverride != null) {
            annotationCommand = annotationCommandOverride;
        } else {
            Class<? extends AnnotationCommand> annotationCommandClass = this.soapCommands.get(operationName);
            if (annotationCommandClass != null) {
                try {
                    Constructor<? extends AnnotationCommand> constructor = annotationCommandClass.getConstructor(MessageContext.class, AnnotationResources.class);
                    annotationCommand = constructor.newInstance(mc, resources);
                }
                catch (Exception e) {
                    throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_COMMAND_INSTANTIATION_ERROR, new Object[]{operationName.getQualifiedName()}, e);
                }
            } else {
                throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_COMMAND_NOT_FOUND, new Object[]{operationName.getQualifiedName()});
            }
        }
        return annotationCommand;
    }

    public AnnotationCommand getRestCommand(RestOP restOperation, MessageContext mc, AnnotationResources resources) throws AnnotationServiceException {
        AnnotationCommand annotationCommand = null;
        AnnotationCommand annotationCommandOverride = this.restCommandOverrides.get(restOperation);
        if (annotationCommandOverride != null) {
            annotationCommand = annotationCommandOverride;
        } else {
            Class<? extends AnnotationCommand> annotationCommandClass = this.restCommands.get(restOperation);
            if (annotationCommandClass != null) {
                try {
                    Constructor<? extends AnnotationCommand> constructor = annotationCommandClass.getConstructor(MessageContext.class, AnnotationResources.class);
                    annotationCommand = constructor.newInstance(mc, resources);
                }
                catch (Exception e) {
                    throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_COMMAND_INSTANTIATION_ERROR, new Object[]{restOperation.toString()}, e);
                }
            } else {
                throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_COMMAND_NOT_FOUND, new Object[]{restOperation.toString()});
            }
        }
        return annotationCommand;
    }

    void addSoapCommand(QName commandName, Class<? extends AnnotationCommand> command) {
        this.soapCommands.put(commandName, command);
    }

    void addRestCommand(RestOP x, Class<? extends AnnotationCommand> y) {
        this.restCommands.put(x, y);
    }

    void addSoapCommandOverride(QName commandName, AnnotationCommand command) {
        this.soapCommandOverrides.put(commandName, command);
    }

    void addRestCommandOverride(RestOP x, AnnotationCommand y) {
        this.restCommandOverrides.put(x, y);
    }
}

