/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.users;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.internal.annotations.exceptions.AnnotationAuthenticationException;
import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import com.ibm.cognos.internal.annotations.metrics.AnnotationPerfMBeanImpl;
import com.ibm.cognos.internal.annotations.users.Authenticator;
import java.util.Date;

public class AuthenticatorImpl
implements Authenticator {
    @Override
    public void authenticate(MessageContext mc) throws AnnotationServiceException {
        BIBusEnvelope request = (BIBusEnvelope)mc.getProperty("request.envelope");
        BiBusHeader header = BiBusUtilities.retrieveHeader((BIBusEnvelope)request);
        JobBiBusHeaders headers = new JobBiBusHeaders(header);
        Date perf_start = new Date();
        try {
            AuthenticatorFactory.getInstance().authenticate(headers);
        }
        catch (EMFSecurityException e) {
            throw new AnnotationAuthenticationException(e);
        }
        catch (SDKClientException e) {
            throw new AnnotationServiceException(AnnotationI18NCode.SDK_CLIENT_EXCEPTION, (Throwable)e);
        }
        finally {
            AnnotationPerfMBeanImpl.getInstance().updateTimeInCM(perf_start, new Date());
        }
    }
}

