/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.users;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.Permission;
import com.cognos.developer.schemas.bibus._3.Policy;
import com.cognos.developer.schemas.bibus._3.PolicyArrayProp;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.jsmcommon.soap.client.IClient;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.cognos.internal.annotations.service.XMLSOAPHelper;
import com.ibm.cognos.internal.annotations.users.CMPolicyProperties;
import com.ibm.cognos.internal.annotations.users.CMPropertiesImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CMPolicyPropertiesImpl
extends CMPropertiesImpl
implements CMPolicyProperties {
    public CMPolicyPropertiesImpl(String baseClassID, IClient cmClient, BIBusEnvelope request, boolean useTrusted) {
        super(baseClassID, cmClient, request, useTrusted);
    }

    public CMPolicyPropertiesImpl(String baseClassID, IClient cmClient, BIBusEnvelope request) {
        super(baseClassID, cmClient, request);
    }

    @Override
    public QueryRequest getRequest() {
        QueryRequest queryRequest = super.getRequest();
        HashSet<PropEnum> props = new HashSet<PropEnum>();
        props.addAll(Arrays.asList(queryRequest.getProperties()));
        props.addAll(Arrays.asList(PropEnum.policies, PropEnum.searchPath, PropEnum.storeID));
        queryRequest.setProperties(props.toArray(new PropEnum[0]));
        return queryRequest;
    }

    @Override
    public Element getPolicies() {
        return this.buildCMPolicies(this.getBaseClass());
    }

    private Element buildCMPolicies(BaseClass parentResult) {
        Document policiesDoc = DocumentHelper.createDocument();
        Element policiesElement = policiesDoc.addElement(XMLSOAPHelper.ANNOTATION_POLICIES);
        if (parentResult != null && parentResult.getPolicies() != null) {
            Element searchPathElement;
            Hashtable grantPermission = new Hashtable();
            Hashtable denyPermission = new Hashtable();
            PolicyArrayProp policiesProp = parentResult.getPolicies();
            if (policiesProp != null) {
                Policy[] policyArray;
                for (Policy policy : policyArray = policiesProp.getValue()) {
                    BaseClass securityObject = policy.getSecurityObject();
                    Permission[] permissions = policy.getPermissions();
                    String searchPath = null;
                    String permissionName = null;
                    String accessName = null;
                    if (securityObject.getSearchPath() != null) {
                        searchPath = securityObject.getSearchPath().getValue();
                    }
                    for (Permission permission : permissions) {
                        permissionName = permission.getName();
                        accessName = permission.getAccess().getValue();
                        Hashtable permissionHash = null;
                        if (accessName.equals("deny")) {
                            permissionHash = denyPermission;
                        } else if (accessName.equals("grant")) {
                            permissionHash = grantPermission;
                        }
                        Set<String> permissionSet = null;
                        if (permissionHash.containsKey(permissionName)) {
                            permissionSet = (Set)permissionHash.get(permissionName);
                        } else {
                            permissionSet = new HashSet();
                            permissionHash.put(permissionName, permissionSet);
                        }
                        permissionSet.add(searchPath);
                    }
                }
            }
            Set grantRead = (Set)grantPermission.get("read");
            Set grantExecute = (Set)grantPermission.get("execute");
            Set grantTraverse = (Set)grantPermission.get("traverse");
            Set denyRead = (Set)denyPermission.get("read");
            Set denyExecute = (Set)denyPermission.get("execute");
            Set denyTraverse = (Set)denyPermission.get("traverse");
            Set<String> grantReadLessDenyRead = this.diff(grantRead, denyRead);
            Set<String> grantExecuteLessDenyExecute = this.diff(grantExecute, denyExecute);
            Set<String> grantTraverseLessDenyTraverse = this.diff(grantTraverse, denyTraverse);
            Set<String> grantExecuteORReadTraverse = this.union(grantExecuteLessDenyExecute, this.intersection(grantReadLessDenyRead, grantTraverseLessDenyTraverse));
            Set<String> denyExecuteORReadTraverse = this.union(denyExecute, this.union(denyRead, denyTraverse));
            if (!grantExecuteORReadTraverse.isEmpty()) {
                Element grantElement = policiesElement.addElement(XMLSOAPHelper.ANNOTATION_GRANT);
                for (String searchPath : grantExecuteORReadTraverse) {
                    searchPathElement = grantElement.addElement(XMLSOAPHelper.ANNOTATION_SEARCHPATH);
                    searchPathElement.addText(searchPath);
                }
            }
            if (!denyExecuteORReadTraverse.isEmpty()) {
                Element denyElement = policiesElement.addElement(XMLSOAPHelper.ANNOTATION_DENY);
                for (String searchPath : denyExecuteORReadTraverse) {
                    searchPathElement = denyElement.addElement(XMLSOAPHelper.ANNOTATION_SEARCHPATH);
                    searchPathElement.addText(searchPath);
                }
            }
        }
        policiesElement.detach();
        return policiesElement;
    }

    private Set<String> union(Set<String> a, Set<String> b) {
        HashSet<String> ret_value = new HashSet<String>();
        if (a != null) {
            ret_value.addAll(a);
        }
        if (b != null) {
            ret_value.addAll(b);
        }
        return ret_value;
    }

    private Set<String> intersection(Set<String> a, Set<String> b) {
        HashSet<String> ret_value = new HashSet<String>();
        if (a == null || a.isEmpty() || b == null || b.isEmpty()) {
            return ret_value;
        }
        for (String aString : a) {
            if (!b.contains(aString)) continue;
            ret_value.add(aString);
        }
        return ret_value;
    }

    private Set<String> diff(Set<String> a, Set<String> b) {
        HashSet<String> ret_value = new HashSet<String>();
        if (a == null || a.isEmpty()) {
            return ret_value;
        }
        ret_value.addAll(a);
        if (b == null || b.isEmpty()) {
            return ret_value;
        }
        Iterator<String> it = b.iterator();
        while (it.hasNext()) {
            ret_value.remove(it.next());
        }
        return ret_value;
    }
}

