/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.users;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.NmtokenArrayProp;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.IClient;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.cognos.internal.annotations.exceptions.AnnotationAuthenticationException;
import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import com.ibm.cognos.internal.annotations.metrics.AnnotationPerfMBeanImpl;
import com.ibm.cognos.internal.annotations.service.XMLSOAPHelper;
import com.ibm.cognos.internal.annotations.users.CMProperties;
import java.util.Date;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CMPropertiesImpl
implements CMProperties {
    private IClient cmClient = null;
    private BIBusEnvelope request = null;
    private BaseClass baseClass = null;
    private String baseClassID;
    boolean useTrusted = false;
    String requestorOperation = null;

    public CMPropertiesImpl(String baseClassID, IClient cmClient, BIBusEnvelope request, boolean useTrusted) {
        this(baseClassID, cmClient, request);
        this.useTrusted = useTrusted;
    }

    public CMPropertiesImpl(String baseClassID, IClient cmClient, BIBusEnvelope request) {
        this.cmClient = cmClient;
        this.request = request;
        this.baseClassID = baseClassID;
    }

    @Override
    public Element getCMRef() {
        return this.buildCMRef(this.baseClass);
    }

    @Override
    public String getDefaultName() {
        String ret_value = "";
        if (this.baseClass != null && this.baseClass.getDefaultName() != null && this.baseClass.getDefaultName().getValue() != null) {
            ret_value = this.baseClass.getDefaultName().getValue();
        }
        return ret_value;
    }

    @Override
    public boolean executePermission() {
        boolean permission = false;
        if (this.baseClass != null) {
            NmtokenArrayProp permissions = this.baseClass.getPermissions();
            permission = this.checkPermissions("execute", permissions);
        }
        return permission;
    }

    @Override
    public boolean readPermission() {
        boolean permission = false;
        if (this.baseClass != null) {
            NmtokenArrayProp permissions = this.baseClass.getPermissions();
            permission = this.checkPermissions("read", permissions);
        }
        return permission;
    }

    @Override
    public boolean traversePermission() {
        boolean permission = false;
        if (this.baseClass != null) {
            NmtokenArrayProp permissions = this.baseClass.getPermissions();
            permission = this.checkPermissions("traverse", permissions);
        }
        return permission;
    }

    @Override
    public boolean writePermission() {
        boolean permission = false;
        if (this.baseClass != null) {
            NmtokenArrayProp permissions = this.baseClass.getPermissions();
            permission = this.checkPermissions("write", permissions);
        }
        return permission;
    }

    @Override
    public boolean exists() {
        return this.baseClass != null;
    }

    private boolean checkPermissions(String permissionName, NmtokenArrayProp permissions) {
        boolean found = false;
        if (permissions != null && permissions.getValue() != null) {
            String[] permissionStrings = permissions.getValue();
            for (int i = 0; i < permissionStrings.length; ++i) {
                if (!permissionName.equalsIgnoreCase(permissionStrings[i])) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    @Override
    public BaseClass getCMInfo() throws AnnotationServiceException {
        BiBusHeader header = BiBusUtilities.retrieveHeader((BIBusEnvelope)this.request);
        if (this.requestorOperation != null) {
            BiBusUtilities.addRequesterDispatcherTransportVar((BiBusHeader)header, (String)("ANS:" + this.requestorOperation));
        }
        JobBiBusHeaders headers = new JobBiBusHeaders(header);
        ContentManagerServiceClientPort cm_port = this.cmClient.getContentManagerServiceClient(headers);
        QueryRequest cmRequest = this.getRequest();
        if (this.useTrusted) {
            cm_port.signNextRequest("ANS");
        }
        BaseClass[] replies = null;
        Date perf_start = new Date();
        try {
            replies = cm_port.query(cmRequest.getSearch(), cmRequest.getProperties(), cmRequest.getSortBy(), cmRequest.getOptions());
        }
        catch (SDKClientException e) {
            throw new AnnotationServiceException(AnnotationI18NCode.SDK_CLIENT_EXCEPTION, (Throwable)e);
        }
        catch (EMFSecurityException e) {
            throw new AnnotationAuthenticationException(e);
        }
        finally {
            AnnotationPerfMBeanImpl.getInstance().incrementCmRequestCount();
            AnnotationPerfMBeanImpl.getInstance().updateTimeInCM(perf_start, new Date());
            if (cm_port != null) {
                cm_port.close();
            }
        }
        if (replies != null && replies.length > 0) {
            this.baseClass = replies[0];
        }
        return this.baseClass;
    }

    private Element buildCMRef(BaseClass cmObj) {
        Document document = DocumentHelper.createDocument();
        Element cmRef = document.addElement(XMLSOAPHelper.ANNOTATION_CMREF);
        if (cmObj != null) {
            Element searchPathElement;
            if (cmObj.getSearchPath() != null && cmObj.getSearchPath().getValue() != null) {
                searchPathElement = cmRef.addElement(XMLSOAPHelper.ANNOTATION_SEARCHPATH);
                searchPathElement.addText(cmObj.getSearchPath().getValue());
            }
            if (cmObj.getStoreID() != null && cmObj.getStoreID().getValue() != null) {
                searchPathElement = cmRef.addElement(XMLSOAPHelper.ANNOTATION_STOREID);
                searchPathElement.addText(cmObj.getStoreID().getValue().get_value());
            }
            if (cmObj.getDefaultName() != null && cmObj.getDefaultName().getValue() != null) {
                searchPathElement = cmRef.addElement(XMLSOAPHelper.ANNOTATION_DEFAULTNAME);
                searchPathElement.addText(cmObj.getDefaultName().getValue());
            }
        }
        cmRef.detach();
        return cmRef;
    }

    @Override
    public QueryRequest getRequest() {
        String parentIDSearchPath = "storeID(\"" + this.baseClassID + "\")";
        QueryRequest queryRequest = new QueryRequest();
        queryRequest.setSearch(parentIDSearchPath);
        queryRequest.setProperties(new PropEnum[]{PropEnum.defaultName, PropEnum.searchPath, PropEnum.storeID, PropEnum.permissions});
        return queryRequest;
    }

    @Override
    public void acceptResult(BaseClass inputBaseClass) {
        this.baseClass = inputBaseClass;
    }

    @Override
    public BaseClass getBaseClass() {
        return this.baseClass;
    }

    public String getRequestorOperation() {
        return this.requestorOperation;
    }

    public void setRequestorOperation(String requestorOperation) {
        this.requestorOperation = requestorOperation;
    }
}

