/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.users;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.IClient;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.cognos.internal.annotations.exceptions.AnnotationAuthenticationException;
import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import com.ibm.cognos.internal.annotations.metrics.AnnotationPerfMBeanImpl;
import com.ibm.cognos.internal.annotations.users.CMProperties;
import com.ibm.cognos.internal.annotations.users.MultiCMProperties;
import java.util.Date;

public class MultiCMPropertiesImpl
implements MultiCMProperties {
    private IClient cmClient = null;
    BIBusEnvelope request = null;
    private CMProperties[] properties;
    private boolean useTrusted = false;
    private String requestorOperation = null;

    public MultiCMPropertiesImpl(CMProperties[] properties, IClient cmClient, BIBusEnvelope request, boolean useTrusted) {
        this(properties, cmClient, request);
        this.useTrusted = useTrusted;
    }

    public MultiCMPropertiesImpl(CMProperties[] properties, IClient cmClient, BIBusEnvelope request) {
        this.properties = properties;
        this.cmClient = cmClient;
        this.request = request;
    }

    @Override
    public QueryReply[] getCMInfo() throws AnnotationServiceException {
        BiBusHeader header = BiBusUtilities.retrieveHeader((BIBusEnvelope)this.request);
        if (this.requestorOperation != null) {
            BiBusUtilities.addRequesterDispatcherTransportVar((BiBusHeader)header, (String)("ANS:" + this.requestorOperation));
        }
        JobBiBusHeaders headers = new JobBiBusHeaders(header);
        ContentManagerServiceClientPort cm_port = this.cmClient.getContentManagerServiceClient(headers);
        QueryRequest[] requests = new QueryRequest[this.properties.length];
        for (int i = 0; i < this.properties.length; ++i) {
            requests[i] = this.properties[i].getRequest();
        }
        if (this.useTrusted) {
            cm_port.signNextRequest("ANS");
        }
        QueryReply[] replies = null;
        Date perf_start = new Date();
        try {
            replies = cm_port.queryMultiple(requests);
        }
        catch (SDKClientException e) {
            throw new AnnotationServiceException(AnnotationI18NCode.SDK_CLIENT_EXCEPTION, (Throwable)e);
        }
        catch (EMFSecurityException e) {
            throw new AnnotationAuthenticationException(e);
        }
        finally {
            AnnotationPerfMBeanImpl.getInstance().incrementCmRequestCount();
            AnnotationPerfMBeanImpl.getInstance().updateTimeInCM(perf_start, new Date());
            if (cm_port != null) {
                cm_port.close();
            }
        }
        if (replies != null) {
            for (int i = 0; i < this.properties.length; ++i) {
                if (i < replies.length) {
                    if (replies[i].getQueryResult() == null || replies[i].getQueryResult().length != 1) continue;
                    this.properties[i].acceptResult(replies[i].getQueryResult()[0]);
                    continue;
                }
                this.properties[i].acceptResult(null);
            }
        }
        return replies;
    }

    public String getRequestorOperation() {
        return this.requestorOperation;
    }

    public void setRequestorOperation(String requestorOperation) {
        this.requestorOperation = requestorOperation;
    }
}

