/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.users;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.RefProp;
import com.cognos.jsmcommon.soap.client.IClient;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.cognos.internal.annotations.users.CMPropertiesImpl;
import com.ibm.cognos.internal.annotations.users.Session;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class SessionImpl
extends CMPropertiesImpl
implements Session {
    public SessionImpl(IClient cmClient, BIBusEnvelope request) {
        super(null, cmClient, request);
    }

    @Override
    public QueryRequest getRequest() {
        QueryRequest queryRequest = super.getRequest();
        queryRequest.setSearch("~~");
        QueryOptions queryOptions = new QueryOptions();
        RefProp refProp = new RefProp();
        refProp.setRefPropName(PropEnum.identity);
        HashSet<PropEnum> parentProps = new HashSet<PropEnum>();
        parentProps.addAll(Arrays.asList(queryRequest.getProperties()));
        parentProps.addAll(Arrays.asList(PropEnum.defaultName, PropEnum.searchPath, PropEnum.storeID, PropEnum.identity));
        refProp.setProperties(parentProps.toArray(new PropEnum[0]));
        HashSet<PropEnum> props = new HashSet<PropEnum>();
        props.addAll(Arrays.asList(queryRequest.getProperties()));
        props.addAll(Arrays.asList(PropEnum.identity));
        queryRequest.setProperties(props.toArray(new PropEnum[0]));
        queryRequest.setOptions(queryOptions);
        return queryRequest;
    }

    public boolean identityContainsAccountSearchPath(String searchPath) {
        boolean found = false;
        BaseClass[] identityAccounts = this.getIdentity();
        if (identityAccounts != null) {
            for (int i = 0; i < identityAccounts.length; ++i) {
                BaseClass account = identityAccounts[i];
                if (!account.getSearchPath().getValue().equals(searchPath)) continue;
                found = true;
            }
        }
        return found;
    }

    public boolean identityContainsAccountStoreID(String storeID) {
        boolean found = false;
        BaseClass[] identityAccounts = this.getIdentity();
        if (identityAccounts != null) {
            for (int i = 0; i < identityAccounts.length; ++i) {
                BaseClass account = identityAccounts[i];
                if (!account.getStoreID().getValue().get_value().equals(storeID)) continue;
                found = true;
            }
        }
        return found;
    }

    @Override
    public boolean isAdministrator() {
        boolean bIsAdministrator = false;
        String[] camIDs = this.getCamIDs();
        if (camIDs != null && camIDs.length > 0) {
            for (int i = 0; i < camIDs.length; ++i) {
                if (!"::System Administrators".equals(camIDs[i])) continue;
                bIsAdministrator = true;
                break;
            }
        }
        return bIsAdministrator;
    }

    @Override
    public BaseClass[] getIdentity() {
        BaseClass[] ownerIdentities = null;
        com.cognos.developer.schemas.bibus._3.Session session = (com.cognos.developer.schemas.bibus._3.Session)this.getBaseClass();
        if (session != null) {
            ownerIdentities = session.getIdentity().getValue();
        }
        return ownerIdentities;
    }

    private String[] getCamIDs() {
        BaseClass[] identityAccounts = this.getIdentity();
        ArrayList<String> camIDs = new ArrayList<String>();
        for (int i = 0; i < identityAccounts.length; ++i) {
            BaseClass account = identityAccounts[i];
            camIDs.add(this.filterCAMID(account.getSearchPath().getValue()));
        }
        return camIDs.toArray(new String[0]);
    }

    private String filterCAMID(String sSearchPath) {
        int idx2;
        if (sSearchPath == null || sSearchPath.length() == 0) {
            return sSearchPath;
        }
        int idx1 = sSearchPath.indexOf(34);
        if (idx1 != -1 && (idx2 = sSearchPath.indexOf(34, ++idx1)) > idx1) {
            sSearchPath = sSearchPath.substring(idx1, idx2);
        }
        return sSearchPath;
    }
}

