/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.cognos.internal.hts.apiHandlers.APIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.AbstractContext;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.perf.HtsPerfData;
import com.ibm.cognos.internal.hts.util.perf.OperationTimings;
import com.ibm.cognos.internal.hts.util.perf.Timing;
import com.ibm.cognos.internal.hts.util.perf.TimingDurationComparator;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.GetPerfDataResponseDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.StartPerfDataCollectionResponseDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.TPerfData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PerfDataHandler
extends APIHandler {
    private boolean start;
    public static final boolean COLLECT_PERF_DATA = false;

    public PerfDataHandler(boolean start) {
        this.start = start;
    }

    @Override
    public void handleRequestImpl(IAbstractContext context) throws HumanTaskServiceException {
        if (this.start) {
            context.setPerfData(new HtsPerfData());
            StartPerfDataCollectionResponseDocument response = StartPerfDataCollectionResponseDocument.Factory.newInstance();
            response.addNewStartPerfDataCollectionResponse();
            context.setAPIResponseObject(response);
        } else {
            GetPerfDataResponseDocument response = GetPerfDataResponseDocument.Factory.newInstance();
            response.addNewGetPerfDataResponse();
            if (context.getPerfData() != null) {
                Collection<OperationTimings> opTimings = context.getPerfData().getOperationMaps();
                TimingSummaryVisitor visitor = new TimingSummaryVisitor();
                for (OperationTimings optiming : opTimings) {
                    visitor.collectTimings(optiming.getOperationTiming());
                }
                List<Timing> flatTimings = visitor.getTimings();
                Collections.sort(flatTimings, new TimingDurationComparator());
                for (Timing timing : flatTimings) {
                    TPerfData perfData = response.getGetPerfDataResponse().addNewPerfData();
                    timing.populateFlatSummary(perfData, 0.0f);
                }
            }
            context.setAPIResponseObject(response);
        }
    }

    @Override
    public IAbstractContext makeContext(BIBusEnvelope requestEnvelope) throws HumanTaskServiceException {
        return new GenericContext(requestEnvelope);
    }

    private class GenericContext
    extends AbstractContext {
        public GenericContext(BIBusEnvelope requestEnvelope) throws HumanTaskServiceException {
            super(requestEnvelope);
        }

        @Override
        public String getTaskId() {
            return null;
        }
    }

    private class TimingSummaryVisitor {
        Map<String, Timing> timingMap = new HashMap<String, Timing>();

        private TimingSummaryVisitor() {
        }

        public void collectTimings(Timing timing) {
            this.addTiming(timing);
            for (Timing childTiming : timing.getChildren()) {
                this.collectTimings(childTiming);
            }
        }

        public List<Timing> getTimings() {
            return new ArrayList<Timing>(this.timingMap.values());
        }

        private void addTiming(Timing timing) {
            if (this.timingMap.containsKey(timing.getName())) {
                this.timingMap.get(timing.getName()).parentOnlyMerge(timing);
            } else {
                this.timingMap.put(timing.getName(), timing);
            }
        }
    }
}

