/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers;

import com.ibm.cognos.internal.hts.apiHandlers.APIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskSubscription;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskclass;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.util.dao.SubscriptionUtil;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.SubscriptionEventState;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.SubscriptionEventType;
import com.ibm.cognos.internal.hts.xpath.XPathEvaluator;
import com.ibm.cognos.internal.hts.xpath.XPathVariableContext;
import java.util.List;
import org.dom4j.Node;

public class SetSubscriptionsHandler
extends APIHandler {
    @Override
    public void handleRequestImpl(IAbstractContext context) throws HumanTaskServiceException {
        if (context != null) {
            HTSTask task = context.getPersistedTask();
            if (task == null) {
                Utils.throwHumanTaskServiceException(UsI18NCode.MSG_US_INVALID_PARAMETER, new Object[]{"ID", context.getOperationName(), context.getTaskId()});
            }
            HTSTaskclass taskClass = task.getHtsTaskclass();
            List<HTSTaskSubscription> subscriptions = taskClass.getTaskSubscriptions();
            for (HTSTaskSubscription taskSubscriptions : subscriptions) {
                HTSTaskSubscription.TASK_SUBSCRIPTIONS type = HTSTaskSubscription.TASK_SUBSCRIPTIONS.valueOf(taskSubscriptions.getType());
                SubscriptionEventState.Enum stateEnum = this.evaluateExpression(taskSubscriptions, task);
                HTSTaskUser user = context.getUsTaskUser();
                String eventType = this.getEventType(type);
                if (eventType != null) {
                    SubscriptionUtil.doSubscription(stateEnum, context, task, user, eventType);
                    continue;
                }
                Utils.throwHumanTaskServiceException(UsI18NCode.MSG_US_INVALID_PARAMETER, new Object[]{"event", context.getOperationName(), type});
            }
        }
        this.handleNextRequest(context);
    }

    private String getEventType(HTSTaskSubscription.TASK_SUBSCRIPTIONS type) {
        SubscriptionEventType.Enum subEvent = SubscriptionEventType.Enum.forString((String)type.name());
        String subEventStr = null;
        if (subEvent != null) {
            subEventStr = subEvent.toString();
        }
        return subEventStr;
    }

    private SubscriptionEventState.Enum evaluateExpression(HTSTaskSubscription subscription, HTSTask task) throws HumanTaskServiceException {
        Node nodeFor;
        SubscriptionEventState.Enum subscriptionValue = SubscriptionEventState.INDIVIDUAL_SUBSCRIBE;
        XPathVariableContext vc = new XPathVariableContext();
        vc.setVariableValue(XPathVariableContext.XPathVariable.TASK, task);
        XPathEvaluator evaluator = new XPathEvaluator(vc);
        String expression = subscription.getSubscriptionExpression();
        if (expression != null && (nodeFor = (Node)evaluator.selectNode(expression)) != null) {
            subscriptionValue = SubscriptionEventState.Enum.forString((String)nodeFor.getText());
        }
        return subscriptionValue;
    }
}

