/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.context;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.jsmcommon.util.HashList;
import com.cognos.jsmcommon.util.Headers;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.cognos.internal.hts.apiHandlers.context.ChangedHumanRoleMode;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.persist.dao.ITransactionHandler;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSHumanRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSMessage;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskOverrides;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskclass;
import com.ibm.cognos.internal.hts.persist.dao.pojo.PojoCache;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.status.StateManagement;
import com.ibm.cognos.internal.hts.util.BiBusHeaderUtilities;
import com.ibm.cognos.internal.hts.util.HTSSDKUtils;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.util.cam.UserUtils;
import com.ibm.cognos.internal.hts.util.dao.MessageUtils;
import com.ibm.cognos.internal.hts.util.perf.HtsPerfData;
import com.ibm.cognos.internal.hts.util.perf.OperationTimings;
import com.ibm.cognos.internal.hts.ws_ht.OrganizationalEntityDocument;
import com.ibm.cognos.internal.hts.ws_ht.TFrom;
import com.ibm.cognos.internal.hts.ws_ht.TGenericHumanRole;
import com.ibm.cognos.internal.hts.ws_ht.TOrganizationalEntity;
import com.ibm.cognos.internal.hts.ws_ht.TPeopleAssignments;
import com.ibm.cognos.internal.hts.ws_ht.TUser;
import com.ibm.cognos.internal.hts.ws_ht.TUserlist;
import com.ibm.cognos.internal.hts.xpath.XPathEvaluator;
import com.ibm.cognos.internal.hts.xpath.XPathVariableContext;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public abstract class AbstractContext
implements IAbstractContext {
    private BIBusEnvelope m_request;
    private StateManagement m_statusManagement;
    private List<IAbstractContext> createContexts = new ArrayList<IAbstractContext>();
    private Headers m_header;
    private String m_operationName;
    private String m_parentOperationName;
    private Element m_operation;
    private Boolean m_ownerChanged = Boolean.FALSE;
    private HTSTaskUser m_user;
    private Headers m_responseHeader;
    private Object m_apiResponseObject;
    private HTSTask m_persistedTask;
    private Set<String> m_currentGroupsAndRoles;
    private static ThreadLocal<ITransactionHandler> m_currentTransaction = new ThreadLocal();
    private XmlObject apiObject;
    private HashMap<String, List<HTSRole.Roles>> m_rolesForTask = new HashMap();
    private HashMap<String, Set<String>> m_groupsForToken = new HashMap();
    private HashMap<String, Set<String>> m_expandedForToken = new HashMap();
    private HashList m_changedHumanRoles = new HashList();
    protected Element m_inputMessageElement = null;
    private HashMap<String, Object> m_properties = new HashMap();
    private static ThreadLocal<Map<String, Object>> m_thread_properties = new ThreadLocal();
    private static PojoCache pojoCache = new PojoCache();
    private List<String> fetchGroups = new ArrayList<String>();
    private HTSTaskOverrides m_overrideTask;
    private static HtsPerfData perfData;
    private OperationTimings operationTimings;

    public AbstractContext(BIBusEnvelope requestEnvelope) throws HumanTaskServiceException {
        this.m_request = requestEnvelope;
        this.m_header = BiBusHeaderUtilities.retrieveHeader(this.m_request);
        Element body = this.m_request.getBody();
        this.setOperation((Element)body.selectSingleNode("./*"));
        this.setOperationName(this.getOperation().getName());
        this.fetchGroups.add("general");
    }

    private HTSHumanRole clone(HTSHumanRole role) {
        return new HTSHumanRole(role.getHtsTaskUser(), role.getHtsRole());
    }

    @Override
    public void addChangedHumanRole(ChangedHumanRoleMode chr, HTSHumanRole role) {
        this.m_changedHumanRoles.put((Object)chr, (Object)this.clone(role));
    }

    @Override
    public List<HTSHumanRole> getChangedHumanRoles(ChangedHumanRoleMode type, HTSRole.Roles role) {
        ArrayList<HTSHumanRole> filtered = new ArrayList<HTSHumanRole>();
        List roles = this.m_changedHumanRoles.getList((Object)type);
        for (HTSHumanRole hRole : roles) {
            if (role != null && !hRole.getHtsRole().getRole().equals(role.getRole())) continue;
            filtered.add(hRole);
        }
        return filtered;
    }

    protected AbstractContext() {
    }

    @Override
    public XmlObject getApiObject() {
        try {
            this.apiObject = HTSSDKUtils.unMarshallElement(this.getOperation());
        }
        catch (Exception e) {
            Utils.logException(e);
        }
        return this.apiObject;
    }

    @Override
    public Headers getHeader() {
        return this.m_header;
    }

    @Override
    public void logon(HTSTaskUser user) {
        if (this.m_header == null) {
            this.m_header = new Headers(null);
        }
        this.m_header.setBiBusHeader(UserUtils.instance().logon(user));
    }

    protected void setHeader(Headers header) {
        this.m_header = header;
    }

    @Override
    public Locale getLocale() {
        Locale locale = LocaleUtil.getRequestProductLocale((BiBusHeader)this.m_header.getBiBusHeader());
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    @Override
    public Locale getDefaultTaskLocale() {
        Locale defaultLocale = null;
        defaultLocale = this.getPersistedTask() != null && this.getPersistedTask().getDefaultLocale() != null ? LocaleUtil.getLocale((String)this.getPersistedTask().getDefaultLocale()) : Locale.getDefault();
        return defaultLocale;
    }

    @Override
    public String getLanguage() {
        Locale locale = LocaleUtil.getRequestProductLocale((BiBusHeader)this.m_header.getBiBusHeader());
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale.getLanguage();
    }

    @Override
    public Object getAPIResponseObject() {
        return this.m_apiResponseObject;
    }

    @Override
    public void setAPIResponseObject(Object apiResponse) {
        this.m_apiResponseObject = apiResponse;
    }

    @Override
    public void setPersistedTask(HTSTask persistedTask) {
        this.m_persistedTask = persistedTask;
    }

    @Override
    public HTSTask getPersistedTask() {
        return this.m_persistedTask;
    }

    @Override
    public abstract String getTaskId();

    @Override
    public Headers getResponseHeader() {
        return this.m_responseHeader == null ? this.m_header : this.m_responseHeader;
    }

    @Override
    public void setResponseHeader(Headers responseHeader) {
        this.m_responseHeader = responseHeader;
    }

    @Override
    public Element getOperation() {
        return this.m_operation;
    }

    @Override
    public String getOperationName() {
        return this.m_operationName;
    }

    @Override
    public StateManagement getStatusManagement() {
        return this.m_statusManagement;
    }

    @Override
    public void setStatusManagement(StateManagement statusManagement) {
        this.m_statusManagement = statusManagement;
    }

    @Override
    public HTSTaskUser getUsTaskUser() throws HumanTaskServiceException {
        if (this.m_user == null) {
            this.m_user = UserUtils.instance().getUser(this.m_header);
        }
        return this.m_user;
    }

    @Override
    public BIBusEnvelope getRequest() {
        return this.m_request;
    }

    @Override
    public void setOperationName(String name) {
        this.m_operationName = name;
    }

    protected void setOperation(Element operation) throws HumanTaskServiceException {
        this.m_operation = operation;
    }

    @Override
    public HTSTaskOverrides getOverrideTask() {
        return this.m_overrideTask;
    }

    @Override
    public void setOverrides(HTSTaskOverrides overrides) {
        this.m_overrideTask = overrides;
    }

    @Override
    public String getParentOperationName() {
        return this.m_parentOperationName;
    }

    @Override
    public void setParentOperationName(String pop) {
        this.m_parentOperationName = pop;
    }

    @Override
    public void setOwnerChanged(Boolean changed) {
        this.m_ownerChanged = changed != null ? changed : Boolean.FALSE;
    }

    @Override
    public Boolean hasOwnerChanged() {
        return this.m_ownerChanged;
    }

    public String getIdFromApiObject(XmlObject object) throws HumanTaskServiceException {
        return HTSSDKUtils.getText(object, "identifier");
    }

    @Override
    public Set<String> getCurrentUserRolesAndGroups() throws HumanTaskServiceException {
        if (this.m_currentGroupsAndRoles == null) {
            this.m_currentGroupsAndRoles = UserUtils.instance().getCurrentUserRolesAndGroups(this.getUsTaskUser(), this);
        }
        return this.m_currentGroupsAndRoles;
    }

    @Override
    public ITransactionHandler getTransactionHandler() {
        return m_currentTransaction.get();
    }

    @Override
    public void setTransactionHandler(ITransactionHandler handler) {
        m_currentTransaction.set(handler);
    }

    public static ITransactionHandler getCurrentTransactionHandler() {
        return m_currentTransaction.get();
    }

    public static void setCurrentTransactionHandler(ITransactionHandler trx) {
        m_currentTransaction.set(trx);
    }

    @Override
    public void addChildTaskCreateContext(IAbstractContext createContext) {
        this.createContexts.add(createContext);
    }

    @Override
    public List<IAbstractContext> getChildTaskCreateContexts() {
        return this.createContexts;
    }

    @Override
    public List<HTSRole.Roles> getRolesForTask(String taskId) {
        return this.m_rolesForTask.get(taskId);
    }

    @Override
    public void setRolesForTask(String taskId, List<HTSRole.Roles> roles) {
        this.m_rolesForTask.put(taskId, roles);
    }

    @Override
    public void setGroupsForToken(String token, Set<String> groups) {
        this.m_groupsForToken.put(token, groups);
    }

    @Override
    public Set<String> getGroupsForToken(String token) {
        return this.m_groupsForToken.get(token);
    }

    @Override
    public Set<String> getExpandTokens(String token) {
        return this.m_expandedForToken.get(token);
    }

    @Override
    public void setExpandTokens(String token, Set<String> expanded) {
        this.m_expandedForToken.put(token, expanded);
    }

    @Override
    public Element getInputMessageElement() {
        HTSMessage htsMessage;
        if (this.m_inputMessageElement == null && this.getPersistedTask() != null && (htsMessage = MessageUtils.getInputMessage(this.getPersistedTask(), null)) != null && htsMessage.getMessage() != null) {
            try {
                SAXReader reader = new SAXReader();
                reader.setMergeAdjacentText(true);
                Document doc = reader.read((Reader)new StringReader(htsMessage.getMessage()));
                this.m_inputMessageElement = doc.getRootElement();
            }
            catch (DocumentException e) {
                Utils.logException(e);
            }
        }
        return this.m_inputMessageElement;
    }

    @Override
    public HtsPerfData getPerfData() {
        return perfData;
    }

    @Override
    public void setPerfData(HtsPerfData perfData) {
        AbstractContext.perfData = perfData;
    }

    @Override
    public OperationTimings getOperationTimings() {
        if (this.operationTimings == null) {
            this.operationTimings = new OperationTimings(this.getOperationName());
        }
        return this.operationTimings;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.m_properties;
    }

    public static Map<String, Object> getThreadProperties() {
        return m_thread_properties.get();
    }

    public static void setThreadProperties(Map<String, Object> props) {
        m_thread_properties.set(props);
    }

    public static PojoCache getPojoCache() {
        return pojoCache;
    }

    protected void addFetchGroup(String group) {
        this.fetchGroups.add(group);
    }

    @Override
    public String[] getFetchGroups() {
        return this.fetchGroups.toArray(new String[0]);
    }

    public HTSTaskclass getTaskClass() {
        return AbstractContext.getPojoCache().getLatestTaskClass(this.getOperationName());
    }

    protected String getValueFromInput(String expression) throws HumanTaskServiceException {
        if (this.getInputMessageElement() != null && expression != null) {
            XPathVariableContext variableContext = new XPathVariableContext();
            variableContext.setVariableValue(XPathVariableContext.XPathVariable.INPUT, this.getInputMessageElement());
            variableContext.setVariableValue(XPathVariableContext.XPathVariable.CONTEXT, this);
            XPathEvaluator evaluator = new XPathEvaluator(variableContext);
            return evaluator.selectNodeValue(expression.trim());
        }
        return null;
    }

    protected TPeopleAssignments[] getPeopleAssignmentsFromInput() throws HumanTaskServiceException {
        HTSTaskclass taskClass = this.getTaskClass();
        TPeopleAssignments peopleAssignments = null;
        if (taskClass != null) {
            String peopleAssignmentsXML = taskClass.getPeopleAssignments();
            try {
                peopleAssignments = TPeopleAssignments.Factory.parse((String)peopleAssignmentsXML);
            }
            catch (XmlException e) {
                e.printStackTrace();
            }
            peopleAssignments = this.processPeopleAssignments(peopleAssignments);
        }
        return new TPeopleAssignments[]{peopleAssignments};
    }

    private TPeopleAssignments processPeopleAssignments(TPeopleAssignments peopleAssignments) throws HumanTaskServiceException {
        if (peopleAssignments == null) {
            return peopleAssignments;
        }
        this.processRoles(peopleAssignments.getBusinessAdministratorsArray());
        this.processRoles(peopleAssignments.getExcludedOwnersArray());
        this.processRoles(peopleAssignments.getPotentialOwnersArray());
        this.processRoles(peopleAssignments.getRecipientsArray());
        this.processRoles(peopleAssignments.getTaskStakeholdersArray());
        this.processRoles(peopleAssignments.getTaskInitiatorArray());
        return peopleAssignments;
    }

    private void processRoles(TGenericHumanRole[] organizationalEntities) throws HumanTaskServiceException {
        for (int i = 0; i < organizationalEntities.length; ++i) {
            TFrom from = organizationalEntities[i].getFrom();
            String expression = HTSSDKUtils.getText((XmlObject)from);
            String resultXml = this.getValueFromInput(expression);
            try {
                XmlObject resultObj = XmlObject.Factory.parse((String)resultXml);
                if (resultObj instanceof TUser) {
                    OrganizationalEntityDocument orgEntDoc = OrganizationalEntityDocument.Factory.newInstance();
                    TOrganizationalEntity orgEnt = orgEntDoc.addNewOrganizationalEntity();
                    TUserlist userList = orgEnt.addNewUsers();
                    userList.addUser(HTSSDKUtils.getText(resultObj));
                    orgEnt.setUsersArray(0, userList);
                    resultObj = orgEnt;
                }
                from.setNil();
                from.addNewLiteral().set(resultObj);
                continue;
            }
            catch (XmlException e) {
                e.printStackTrace();
            }
        }
    }
}

