/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.context;

import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.cognos.internal.hts.apiHandlers.context.AbstractContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSCallback;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSCallbackParam;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.dao.CallbackUtilities;
import java.util.List;

public abstract class AbstractCreateManualTaskPersistHandler
extends AbstractContext {
    private String m_taskId;
    private String m_eventId;
    private String m_credential;

    public AbstractCreateManualTaskPersistHandler(BIBusEnvelope requestEnvelope) throws HumanTaskServiceException {
        super(requestEnvelope);
    }

    public void processCallbackInfo() throws HumanTaskServiceException {
        HTSCallback callback = CallbackUtilities.parseRequestHeader(this.getHeader());
        if (callback == null) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_MISSING_CALLBACK_HEADER, new Object[]{this.m_taskId, null});
        }
        List<HTSCallbackParam> callbackParams = callback.getHtsCallbackparams();
        for (HTSCallbackParam callbackparam : callbackParams) {
            if (callbackparam.getQname().indexOf(CallbackUtilities.TASK_ID_REF_PARAM.getLocalPart()) != -1) {
                this.m_taskId = callbackparam.getValue();
                continue;
            }
            if (callbackparam.getQname().indexOf(CallbackUtilities.EVENT_ID_REF_PARAM.getLocalPart()) == -1) continue;
            this.m_eventId = callbackparam.getValue();
        }
        this.m_credential = callback.getCredential();
        if (this.m_credential == null) {
            this.m_credential = this.getHeader().getCredential();
        }
    }

    public String getCredential() {
        return this.m_credential;
    }

    @Override
    public String getTaskId() {
        return this.m_taskId;
    }

    public String getEventId() {
        return this.m_eventId;
    }

    public String getPassport() {
        return new JobBiBusHeaders(this.getHeader().getBiBusHeader()).getPassport();
    }
}

