/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.context;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.cognos.internal.hts.apiHandlers.context.AbstractContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSFolder;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.HTSSDKUtils;
import com.ibm.cognos.internal.hts.util.dao.FolderUtils;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.AssignFolderToTasksDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.FolderAction;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.FolderUpdateAction;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.TaskIdList;
import java.util.ArrayList;
import java.util.List;

public class AssignFolderToTaskContext
extends AbstractContext {
    private AssignFolderToTasksDocument.AssignFolderToTasks m_assignfolderToTasks;
    private List<HTSTask> taskList = new ArrayList<HTSTask>();

    public AssignFolderToTaskContext(BIBusEnvelope requestEnvelope) throws HumanTaskServiceException {
        super(requestEnvelope);
        try {
            AssignFolderToTasksDocument assignFolderDoc = (AssignFolderToTasksDocument)HTSSDKUtils.unMarshallElement(super.getOperation());
            this.m_assignfolderToTasks = assignFolderDoc.getAssignFolderToTasks();
        }
        catch (Exception e) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_GENERAL_ERROR, e);
        }
    }

    public List<HTSFolder> getAddFolders() throws HumanTaskServiceException {
        return this.getFolders(FolderUpdateAction.ADD);
    }

    public List<HTSFolder> getRemoveFolders() throws HumanTaskServiceException {
        return this.getFolders(FolderUpdateAction.REMOVE);
    }

    private List<HTSFolder> getFolders(FolderUpdateAction.Enum action) throws HumanTaskServiceException {
        ArrayList<HTSFolder> htsFolders = new ArrayList<HTSFolder>();
        FolderAction[] folderActions = this.m_assignfolderToTasks.getFolderActionArray();
        for (int i = 0; i < folderActions.length; ++i) {
            if ((folderActions[i] != null || !action.equals(FolderUpdateAction.ADD)) && !action.equals(folderActions[i].getAction())) continue;
            List<HTSFolder> folders = FolderUtils.getFolders(folderActions[i], this.getUsTaskUser(), this.taskList);
            htsFolders.addAll(folders);
        }
        return htsFolders;
    }

    @Override
    public String getTaskId() {
        return null;
    }

    public TaskIdList getTaskIds() {
        return this.m_assignfolderToTasks.getTaskIds();
    }

    public void setTaskList(List<HTSTask> taskList) {
        this.taskList = taskList;
    }

    public void addTask(HTSTask task) {
        this.taskList.add(task);
    }
}

