/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.context;

import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.cognos.internal.hts.apiHandlers.context.AbstractContext;
import com.ibm.cognos.internal.hts.apiHandlers.util.TseOutputInterpreter;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.dao.CallbackUtilities;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;

public class CompleteManualTaskContext
extends AbstractContext {
    private String m_taskId;
    private String m_eventId;
    private String m_credential;
    private String m_targetStatus;
    private TseOutputInterpreter m_outputInterpreter = null;

    public CompleteManualTaskContext(BIBusEnvelope requestEnvelope) throws HumanTaskServiceException {
        super(requestEnvelope);
        try {
            this.processCallbackInfo();
        }
        catch (Exception e) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_GENERAL_ERROR, e);
        }
    }

    public String getCompleteData() {
        Node node = this.getOperation().selectSingleNode("./*");
        return node == null ? "" : node.asXML();
    }

    public void processCallbackInfo() throws HumanTaskServiceException {
        List headers = this.getHeader().getExtraHeaders();
        for (Element element : headers) {
            if (element.getName().indexOf(CallbackUtilities.TASK_ID_REF_PARAM.getLocalPart()) != -1) {
                this.m_taskId = element.getText();
                continue;
            }
            if (element.getName().indexOf(CallbackUtilities.EVENT_ID_REF_PARAM.getLocalPart()) != -1) {
                this.m_eventId = element.getText();
                continue;
            }
            if (element.getName().indexOf(CallbackUtilities.STATUS_FLAG_REF_PARAM.getLocalPart()) == -1) continue;
            this.m_targetStatus = element.getText();
        }
        if (this.m_taskId == null || this.m_eventId == null) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_MISSING_CALLBACK_HEADER, new Object[]{this.m_taskId, null});
        }
        this.m_credential = this.getHeader().getCredential();
    }

    public TseOutputInterpreter getOutputInterpreter() {
        return this.m_outputInterpreter;
    }

    public void setOutputInterpreter(TseOutputInterpreter outputInterpreter) {
        this.m_outputInterpreter = outputInterpreter;
    }

    public String getCredential() {
        return this.m_credential;
    }

    public String getStatus() throws HumanTaskServiceException {
        return this.m_targetStatus;
    }

    @Override
    public String getTaskId() {
        return this.m_taskId;
    }

    public String getEventId() {
        return this.m_eventId;
    }

    public String getPassport() {
        return new JobBiBusHeaders(this.getHeader().getBiBusHeader()).getPassport();
    }
}

