/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.context;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.cognos.internal.hts._1.BeplTaskDocument;
import com.ibm.cognos.internal.hts._1.CogBeplTask;
import com.ibm.cognos.internal.hts.apiHandlers.context.CreateContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSAttachment;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSHumanRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSPresentationElements;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskclass;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.TimeUtils;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.util.dao.AttachmentsUtil;
import com.ibm.cognos.internal.hts.util.dao.PresentationElementUtils;
import com.ibm.cognos.internal.hts.util.dao.humanrole.HumanRoleOrganizationalEntityConverter;
import com.ibm.cognos.internal.hts.ws_ht.TPeopleAssignments;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.FolderAction;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.PublicFolder;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import org.apache.xmlbeans.XmlException;
import org.dom4j.Element;
import org.dom4j.Node;

public class CreateManualTaskContext
extends CreateContext {
    private CogBeplTask m_beplTask;

    public CreateManualTaskContext(BIBusEnvelope requestEnvelope) throws HumanTaskServiceException {
        super(requestEnvelope);
    }

    @Override
    protected void processOperationData() throws HumanTaskServiceException {
        try {
            Element cogBepltaskElement = (Element)super.getOperation().selectSingleNode("./*[local-name()='beplTask']");
            if (cogBepltaskElement != null) {
                this.m_beplTask = BeplTaskDocument.Factory.parse((String)cogBepltaskElement.asXML()).getBeplTask();
            }
        }
        catch (Exception e) {
            Utils.throwHumanTaskServiceException(e, UsI18NCode.MSG_US_SERVICE_HANDLER_ERROR, new Object[]{"CreateApproveManualTask", e.getLocalizedMessage()});
        }
    }

    public HTSTaskUser getCreatedBy() throws HumanTaskServiceException {
        return this.getUsTaskUser();
    }

    public Calendar getExpirationTime() throws HumanTaskServiceException {
        String expression;
        String value;
        if (this.getBeplTask() != null) {
            return this.getBeplTask().getExpirationTime();
        }
        HTSTaskclass taskClass = this.getTaskClass();
        if (taskClass != null && (value = this.getValueFromInput(expression = taskClass.getExpirationTime())) != null) {
            return TimeUtils.getCalendar(value);
        }
        return null;
    }

    public Calendar getActivationTime() throws HumanTaskServiceException {
        String expression;
        String value;
        if (this.getBeplTask() != null) {
            return this.getBeplTask().getActivationTime();
        }
        HTSTaskclass taskClass = this.getTaskClass();
        if (taskClass != null && (value = this.getValueFromInput(expression = taskClass.getActivationTime())) != null) {
            return TimeUtils.getCalendar(value);
        }
        return null;
    }

    public Collection<HTSPresentationElements> getPresentationElements() {
        if (this.getBeplTask() != null && this.getBeplTask().getPresentationElements() != null) {
            return PresentationElementUtils.makePresentationElements(this.getBeplTask().getPresentationElements());
        }
        return null;
    }

    public String getName() {
        String name = "";
        if (this.getBeplTask() != null) {
            name = this.getBeplTask().getName();
        } else {
            Node nameNode = this.getInputMessageElement().selectSingleNode("./*[1]/@name");
            if (nameNode != null) {
                name = nameNode.getText();
            }
        }
        return name;
    }

    public HTSAttachment[] getAttachments() {
        if (this.getBeplTask() != null) {
            return AttachmentsUtil.makeAttachments(this.getBeplTask().getAttachmentArray());
        }
        return null;
    }

    public List<HTSHumanRole> getUsHumanroles() throws HumanTaskServiceException {
        HumanRoleOrganizationalEntityConverter humanRoleConverter = new HumanRoleOrganizationalEntityConverter(this);
        return humanRoleConverter.processPeopleAssignments(this.getPeopleAssignments());
    }

    public int getPriority() throws HumanTaskServiceException {
        String expression;
        String value;
        if (this.getBeplTask() != null) {
            return this.getBeplTask().getPriority().intValue();
        }
        HTSTaskclass taskClass = this.getTaskClass();
        if (taskClass != null && (value = this.getValueFromInput(expression = taskClass.getPriority())) != null) {
            return Integer.valueOf(value);
        }
        return 0;
    }

    public TPeopleAssignments[] getPeopleAssignments() throws HumanTaskServiceException {
        TPeopleAssignments[] peopleAssignmentsArray = new TPeopleAssignments[]{};
        peopleAssignmentsArray = this.getBeplTask() != null ? this.getBeplTask().getPeopleAssignmentsArray() : this.getPeopleAssignmentsFromInput();
        return peopleAssignmentsArray;
    }

    CogBeplTask getBeplTask() {
        return this.m_beplTask;
    }

    @Override
    public String getTaskId() {
        return null;
    }

    @Override
    protected FolderAction getAPIFolders() throws HumanTaskServiceException {
        FolderAction folderAction = null;
        if (this.getBeplTask() != null) {
            folderAction = this.getBeplTask().getFolders();
        } else {
            String folders;
            HTSTaskclass taskClass = this.getTaskClass();
            if (taskClass != null && (folders = taskClass.getFolders()) != null) {
                try {
                    folderAction = FolderAction.Factory.parse((String)folders);
                    if (folderAction.sizeOfPublicFolderArray() > 0) {
                        PublicFolder folder = folderAction.getPublicFolderArray(0);
                        String expression = folder.getName();
                        String value = this.getValueFromInput(expression);
                        folder.setName(value);
                    }
                }
                catch (XmlException e) {
                    e.printStackTrace();
                }
            }
        }
        return folderAction;
    }
}

