/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.context;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.cognos.internal.hts.apiHandlers.context.AbstractContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskclass;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.HTSSDKUtils;
import com.ibm.cognos.internal.hts.util.dao.builder.NotificationTaskclassBuilder;
import com.ibm.cognos.internal.hts.util.dao.builder.TaskclassBuilder;
import com.ibm.cognos.internal.hts.ws_ht.HumanInteractionsDocument;
import com.ibm.cognos.internal.hts.ws_ht.TImport;
import com.ibm.cognos.internal.hts.ws_ht.TLogicalPeopleGroup;
import com.ibm.cognos.internal.hts.ws_ht.TLogicalPeopleGroups;
import com.ibm.cognos.internal.hts.ws_ht.TNotifications;
import com.ibm.cognos.internal.hts.ws_ht.TTasks;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;

public class DefineHumanInteractionContext
extends AbstractContext {
    private HumanInteractionsDocument m_humanInteractions;
    private TTasks m_tasks;
    private TNotifications m_notifications;
    private TLogicalPeopleGroups m_logicalPeopleGroups;
    private String m_targetNameSpace;
    private boolean m_setCallPersistHandler;
    private List<String> m_taskclassVersionIdList;

    public DefineHumanInteractionContext(BIBusEnvelope requestEnvelope) throws HumanTaskServiceException {
        super(requestEnvelope);
        try {
            this.m_humanInteractions = HumanInteractionsDocument.Factory.parse((String)super.getOperation().asXML());
            this.m_tasks = this.m_humanInteractions.getHumanInteractions().getTasks();
            this.m_notifications = this.m_humanInteractions.getHumanInteractions().getNotifications();
            this.m_logicalPeopleGroups = this.m_humanInteractions.getHumanInteractions().getLogicalPeopleGroups();
            this.m_targetNameSpace = this.m_humanInteractions.getHumanInteractions().getTargetNamespace();
            this.m_taskclassVersionIdList = new ArrayList<String>();
        }
        catch (Throwable e) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_GENERAL_ERROR, e);
        }
    }

    public int getTaskCount() {
        int count = 0;
        if (this.m_tasks != null) {
            count = this.m_tasks.sizeOfTaskArray();
        }
        return count;
    }

    public int getNotificationCount() {
        int count = 0;
        if (this.m_notifications != null) {
            count = this.m_notifications.sizeOfNotificationArray();
        }
        return count;
    }

    @Override
    public String getTaskId() {
        return null;
    }

    public QName getTaskQName(int index) {
        QName name = null;
        if (this.m_tasks != null && this.m_tasks.sizeOfTaskArray() >= index + 1) {
            name = this.makeQName(this.m_tasks.getTaskArray(index).getName());
        }
        return name;
    }

    public String getTaskVersion(int index) {
        String versionId = null;
        if (this.m_tasks != null && this.m_tasks.sizeOfTaskArray() >= index + 1) {
            try {
                versionId = HTSSDKUtils.getTaskclassVersionId(this.m_tasks.getTaskArray(index).copy());
            }
            catch (HumanTaskServiceException humanTaskServiceException) {
                // empty catch block
            }
        }
        return versionId;
    }

    public QName getNotificationQName(int index) {
        QName name = null;
        if (this.m_notifications != null && this.m_notifications.sizeOfNotificationArray() >= index + 1) {
            name = this.makeQName(this.m_notifications.getNotificationArray(index).getName());
        }
        return name;
    }

    private QName makeQName(String name) {
        return new QName(this.m_targetNameSpace, name);
    }

    public HTSTaskclass makeTaskClass(int index) throws HumanTaskServiceException {
        HTSTaskclass tClass = null;
        TImport[] imp = this.m_humanInteractions.getHumanInteractions().getImportArray();
        if (this.m_tasks != null && this.m_tasks.sizeOfTaskArray() >= index + 1) {
            tClass = new TaskclassBuilder().makeTaskclass(this.m_tasks.getTaskArray(index), imp, this.makeQName(this.m_tasks.getTaskArray(index).getName()));
        }
        return tClass;
    }

    public HTSTaskclass makeNotificationClass(int index) throws HumanTaskServiceException {
        HTSTaskclass tClass = null;
        TImport[] imp = this.m_humanInteractions.getHumanInteractions().getImportArray();
        if (this.m_notifications != null && this.m_notifications.sizeOfNotificationArray() >= index + 1) {
            tClass = new NotificationTaskclassBuilder().makeTaskclass(this.m_notifications.getNotificationArray(index), imp, this.makeQName(this.m_notifications.getNotificationArray(index).getName()));
        }
        return tClass;
    }

    public TLogicalPeopleGroup[] getLogicalPeopleGroupArray() throws HumanTaskServiceException {
        TLogicalPeopleGroup[] result = new TLogicalPeopleGroup[]{};
        if (this.m_logicalPeopleGroups != null) {
            result = this.m_logicalPeopleGroups.getLogicalPeopleGroupArray();
        }
        return result;
    }

    public boolean isCallPersistHandler() {
        return this.m_setCallPersistHandler;
    }

    public void setCallPersistHandler(boolean setCallPersistHandler) {
        this.m_setCallPersistHandler = setCallPersistHandler;
    }

    public String getTaskclassVersion(int index) {
        return this.m_taskclassVersionIdList.get(index);
    }

    public void setTaskclassVersion(String taskclassVersionId) {
        if (taskclassVersionId == null) {
            taskclassVersionId = new String();
        }
        this.m_taskclassVersionIdList.add(taskclassVersionId);
    }
}

