/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.context;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.cognos.internal.hts.apiHandlers.context.AbstractContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.logicalPeopleGroup.LogicalPeopleGroupSupportFactory;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSHumanRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.HTSSDKUtils;
import com.ibm.cognos.internal.hts.util.cam.UserUtils;
import com.ibm.cognos.internal.hts.util.dao.HumanroleUtils;
import com.ibm.cognos.internal.hts.util.dao.humanrole.HumanRoleOrganizationalEntityConverter;
import com.ibm.cognos.internal.hts.ws_ht.TOrganizationalEntity;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.DelegateDocument;
import java.util.List;

public class DelegateContext
extends AbstractContext {
    private DelegateDocument m_delegate;

    public DelegateContext(BIBusEnvelope requestEnvelope) throws HumanTaskServiceException {
        super(requestEnvelope);
        try {
            this.m_delegate = (DelegateDocument)HTSSDKUtils.unMarshallElement(super.getOperation());
        }
        catch (Exception e) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_GENERAL_ERROR, e);
        }
    }

    @Override
    public String getTaskId() {
        return this.m_delegate.getDelegate().getIdentifier();
    }

    public HTSHumanRole getUsHumanrole() throws HumanTaskServiceException {
        HTSHumanRole humanRole = null;
        try {
            TOrganizationalEntity oe = this.m_delegate.getDelegate().getOrganizationalEntity();
            HTSRole hTSRole = HumanroleUtils.getRole(HTSRole.Roles.POTENTIAL_OWNERS);
            List<HTSTaskUser> userList = UserUtils.instance().getUsers(oe, LogicalPeopleGroupSupportFactory.getInstance().getDefaultLogicalPeopleGroup());
            HumanRoleOrganizationalEntityConverter converter = new HumanRoleOrganizationalEntityConverter(this);
            humanRole = converter.getHumanRolePojo(userList, hTSRole).get(0);
        }
        catch (HumanTaskServiceException e) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_ERROR_GENERATING_TASK_HUMANROLE_LOG_DATA, (Throwable)((Object)e));
        }
        return humanRole;
    }
}

