/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.context;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.cognos.internal.hts.apiHandlers.context.AbstractCommentsContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.HTSSDKUtils;
import com.ibm.cognos.internal.hts.ws_ht.api.TComment;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.CommentType;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.GetCommentsByTypeDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.GetCommentsByTypeGroup;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.GetCommentsByTypeResponseDocument;
import java.util.List;

public class GetCommentsByTypeContext
extends AbstractCommentsContext {
    private GetCommentsByTypeDocument m_getCommentsByType;

    public GetCommentsByTypeContext(BIBusEnvelope requestEnvelope) throws HumanTaskServiceException {
        super(requestEnvelope);
        try {
            this.m_getCommentsByType = (GetCommentsByTypeDocument)HTSSDKUtils.unMarshallElement(super.getOperation());
        }
        catch (Exception e) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_GENERAL_ERROR, e);
        }
    }

    @Override
    public String getTaskId() {
        return this.m_getCommentsByType.getGetCommentsByType().getIdentifier();
    }

    @Override
    public CommentType.Enum[] getCommentsType() {
        return this.m_getCommentsByType.getGetCommentsByType().getCommentTypeArray();
    }

    @Override
    public void processResponse() {
        CommentType.Enum[] types = this.getCommentsType();
        GetCommentsByTypeResponseDocument response = GetCommentsByTypeResponseDocument.Factory.newInstance();
        GetCommentsByTypeResponseDocument.GetCommentsByTypeResponse commentsResponse = response.addNewGetCommentsByTypeResponse();
        for (int i = 0; i < types.length; ++i) {
            List<TComment> comments = this.getResponseComments(types[i]);
            if (comments == null) continue;
            GetCommentsByTypeGroup group = commentsResponse.addNewGetCommentsByTypeGroup();
            group.setCommentArray(comments.toArray(new TComment[0]));
            group.setCommentType(types[i]);
        }
        this.setAPIResponseObject(response);
    }
}

