/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.context;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.cognos.internal.hts.apiHandlers.context.AbstractCommentsContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.CommentComparator;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.HTSSDKUtils;
import com.ibm.cognos.internal.hts.ws_ht.api.TComment;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.CommentType;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.GetCommentsDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.GetCommentsResponseDocument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GetCommentsContext
extends AbstractCommentsContext {
    private GetCommentsDocument m_getComments;

    public GetCommentsContext(BIBusEnvelope requestEnvelope) throws HumanTaskServiceException {
        super(requestEnvelope);
        try {
            this.m_getComments = (GetCommentsDocument)HTSSDKUtils.unMarshallElement(super.getOperation());
        }
        catch (Exception e) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_GENERAL_ERROR, e);
        }
    }

    @Override
    public String getTaskId() {
        return this.m_getComments.getGetComments().getIdentifier();
    }

    @Override
    public CommentType.Enum[] getCommentsType() {
        return new CommentType.Enum[]{CommentType.USER, CommentType.AUDIT};
    }

    @Override
    public void processResponse() {
        CommentType.Enum[] types = this.getCommentsType();
        GetCommentsResponseDocument response = GetCommentsResponseDocument.Factory.newInstance();
        ArrayList<TComment> commentsList = new ArrayList<TComment>();
        GetCommentsResponseDocument.GetCommentsResponse commentResponse = response.addNewGetCommentsResponse();
        for (int i = 0; i < types.length; ++i) {
            List<TComment> comments = this.getResponseComments(types[i]);
            if (comments == null) continue;
            commentsList.addAll(comments);
        }
        Collections.sort(commentsList, new CommentComparator());
        commentResponse.setCommentArray(commentsList.toArray(new TComment[0]));
        this.setAPIResponseObject(response);
    }
}

