/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.deadline;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.cognos.internal.hts.apiHandlers.context.AbstractContext;
import com.ibm.cognos.internal.hts.deadlines.RunnerParams;
import com.ibm.cognos.internal.hts.persist.dao.DAOFactory;
import com.ibm.cognos.internal.hts.persist.dao.ITransactionHandler;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSDeadline;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import org.apache.openjpa.persistence.jdbc.FetchMode;

public class DeadlineRunContext
extends AbstractContext {
    private HTSDeadline m_deadLine;

    public DeadlineRunContext(BIBusEnvelope requestEnvelope, RunnerParams params, ITransactionHandler trx) throws HumanTaskServiceException {
        super(requestEnvelope);
        super.setTransactionHandler(trx);
        this.refresh(params);
    }

    private void refresh(RunnerParams params) {
        String taskId = params.getTask();
        HTSTask task = null;
        if (taskId != null) {
            task = (HTSTask)DAOFactory.getFactory().buildTaskDAO().findById(taskId, new String[]{"deadlines"}, FetchMode.JOIN);
        }
        this.setPersistedTask(task);
        this.m_deadLine = params.getDeadline();
        if (this.m_deadLine != null) {
            this.m_deadLine = (HTSDeadline)AbstractContext.getCurrentTransactionHandler().getEntityManager().merge((Object)this.m_deadLine);
        }
    }

    public HTSDeadline getUsDeadline() {
        return this.m_deadLine;
    }

    @Override
    public String getTaskId() {
        return this.getPersistedTask().getId();
    }
}

